/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.Validation;
import org.basex.query.func.validate.ValidationHandler;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.TokenList;
import org.xml.sax.SAXException;

abstract class ValidateFn
extends StandardFunc {
    private static final String REPORT = "report";
    private static final String MESSAGE = "message";
    private static final String STATUS = "status";
    private static final String VALID = "valid";
    private static final String INVALID = "invalid";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final String LEVEL = "level";
    private static final String URL = "url";

    ValidateFn() {
    }

    protected final Empty check(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        if (errors.isEmpty()) {
            return Empty.VALUE;
        }
        throw QueryError.VALIDATE_ERROR_X.get(this.info, errors.get(0).toString());
    }

    protected final Value info(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        TokenList tl = new TokenList(errors.size());
        for (ErrorInfo error : errors) {
            tl.add(error.toString());
        }
        return StrSeq.get(tl);
    }

    protected final FElem report(QueryContext qc) throws QueryException {
        ArrayList<ErrorInfo> errors = this.errors(qc);
        FElem report = new FElem(REPORT);
        report.add(new FElem(STATUS).add(errors.isEmpty() ? VALID : INVALID));
        for (ErrorInfo ei : errors) {
            FElem error = new FElem(MESSAGE);
            error.add(LEVEL, ei.level);
            if (ei.line != Integer.MIN_VALUE) {
                error.add(LINE, Token.token(ei.line));
            }
            if (ei.column != Integer.MIN_VALUE) {
                error.add(COLUMN, Token.token(ei.column));
            }
            if (ei.url != null) {
                error.add(URL, ei.url);
            }
            error.add(ei.message);
            report.add(error);
        }
        return report;
    }

    public abstract ArrayList<ErrorInfo> errors(QueryContext var1) throws QueryException;

    protected final ArrayList<ErrorInfo> process(Validation v) throws QueryException {
        ValidationHandler handler = new ValidationHandler();
        try {
            v.process(handler);
        }
        catch (SAXException ex) {
            Util.rootException(ex);
            handler.add(ex, "Fatal");
        }
        catch (IOException | Error | ParserConfigurationException ex) {
            throw QueryError.VALIDATE_START_X.get(this.info, ex);
        }
        finally {
            v.finish();
        }
        return handler.getErrors();
    }

    protected final IO read(Item item, SerializerOptions sopts) throws QueryException, IOException {
        if (item instanceof ANode) {
            IOContent io = new IOContent(item.serialize(sopts).finish());
            io.name(Token.string(((ANode)item).baseURI()));
            return io;
        }
        if (item.type.isStringOrUntyped()) {
            IO io = this.checkPath(this.toToken(item));
            if (sopts != null) {
                io = new IOContent(new DBNode(io).serialize(sopts).finish());
                io.name(io.path());
            }
            return io;
        }
        throw QueryError.STRNOD_X_X.get(this.info, item.type, item);
    }
}

