/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnCount;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.util.InputInfo;

public final class UtilWithin
extends StandardFunc {
    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        long min = this.toLong(this.exprs[1], qc);
        long max = this.exprs.length == 2 ? Long.MAX_VALUE : (this.exprs[1] == this.exprs[2] ? min : this.toLong(this.exprs[2], qc));
        Iter iter = this.exprs[0].iter(qc);
        long size = iter.size();
        if (size == -1L) {
            if (max == Long.MAX_VALUE) {
                while (++size < min && qc.next(iter) != null) {
                }
            } else {
                while (++size <= max && qc.next(iter) != null) {
                }
            }
        }
        return Bln.get(size >= min && size <= max);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr arg;
        long max;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        Int expr3 = this.exprs.length > 2 ? this.exprs[2] : Int.MAX;
        long min = expr2 instanceof Value ? this.toLong(expr2, cc.qc) : Long.MIN_VALUE;
        long l = max = expr3 instanceof Value ? this.toLong(expr3, cc.qc) : Long.MIN_VALUE;
        if (min != Long.MIN_VALUE && max != Long.MIN_VALUE) {
            if (min > max) {
                return Bln.FALSE;
            }
            if (min <= 0L && max == Long.MAX_VALUE) {
                return Bln.TRUE;
            }
            long size = expr1.size();
            if (size >= 0L && !expr1.has(Flag.NDT)) {
                return Bln.get(size >= min && size <= max);
            }
            if (max == 0L) {
                return cc.function(Function.EMPTY, this.info, expr1);
            }
            if (min == 1L && max == Long.MAX_VALUE) {
                return cc.function(Function.EXISTS, this.info, expr1);
            }
            if (expr1.seqType().zeroOrOne()) {
                if (min < 1L && max <= 1L) {
                    return Bln.TRUE;
                }
                if (min >= 2L) {
                    return Bln.FALSE;
                }
            }
        }
        if ((arg = FnCount.simplify(expr1, cc)) != expr1) {
            Expr[] args = (Expr[])this.exprs.clone();
            args[0] = arg;
            return cc.function(Function._UTIL_WITHIN, this.info, args);
        }
        return this;
    }
}

