/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.sql.JDBCConnections;
import org.basex.query.func.sql.SqlFn;
import org.basex.query.value.item.Uri;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.options.Options;

public final class SqlConnect
extends SqlFn {
    private static final String AUTOCOMMIT = "autocommit";
    private static final String USER = "user";
    private static final String PASS = "password";

    @Override
    public Uri item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkCreate(qc);
        String url = Token.string(this.toToken(this.exprs[0], qc));
        JDBCConnections jdbc = SqlConnect.jdbc(qc);
        try {
            Connection conn;
            if (this.exprs.length > 2) {
                String user = Token.string(this.toToken(this.exprs[1], qc));
                String pass = Token.string(this.toToken(this.exprs[2], qc));
                if (this.exprs.length == 4) {
                    HashMap<String, String> options = this.toOptions(3, new Options(), qc).free();
                    Properties props = new Properties();
                    options.forEach((key, value) -> {
                        if (!key.equals(AUTOCOMMIT)) {
                            props.setProperty((String)key, (String)value);
                        }
                    });
                    props.setProperty(USER, user);
                    props.setProperty(PASS, pass);
                    conn = DriverManager.getConnection(url, props);
                    if (options.containsKey(AUTOCOMMIT)) {
                        conn.setAutoCommit(Strings.toBoolean(options.get(AUTOCOMMIT)));
                    }
                } else {
                    conn = DriverManager.getConnection(url, user, pass);
                }
            } else {
                conn = DriverManager.getConnection(url);
            }
            return jdbc.add(conn, url);
        }
        catch (SQLException ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }
}

