/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.math;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.func.math.MathFn;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class MathPow
extends MathFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item base = this.exprs[0].atomItem(qc, this.info);
        double exp = this.toDouble(this.exprs[1], qc);
        return base == Empty.VALUE ? Empty.VALUE : Dbl.get(MathPow.power(this.toDouble(base), exp));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr base = this.exprs[0];
        if (base instanceof ANum && ((ANum)base).dbl() == 1.0) {
            return Dbl.ONE;
        }
        Expr exp = this.exprs[1];
        if (exp instanceof ANum) {
            double e = ((ANum)exp).dbl();
            if (e == 0.0) {
                return Dbl.ONE;
            }
            if (e == 1.0) {
                return new Cast(this.sc, this.info, base, SeqType.DOUBLE_O).optimize(cc);
            }
        }
        return super.opt(cc);
    }

    private static double power(double base, double exp) {
        if (base == 1.0) {
            return 1.0;
        }
        if (base == -1.0) {
            if (Double.isNaN(exp)) {
                return -1.0;
            }
            if (Double.isInfinite(exp)) {
                return 1.0;
            }
        }
        return StrictMath.pow(base, exp);
    }
}

