/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.jobs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.jobs.Jobs;
import org.basex.core.jobs.JobsOptions;
import org.basex.core.jobs.QueryJob;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;

public class JobsEval
extends StandardFunc {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.eval(this.toQuery(0, qc), qc);
    }

    final Str eval(IOContent query, QueryContext qc) throws QueryException {
        this.checkAdmin(qc);
        HashMap<String, Value> bindings = this.toBindings(1, qc);
        JobsOptions opts = this.toOptions(2, new JobsOptions(), qc);
        opts.set(JobsOptions.BASE_URI, this.toBaseUri(query.url(), opts));
        boolean service = Boolean.TRUE.equals(opts.get(JobsOptions.SERVICE));
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            opts.put(JobsOptions.SERVICE, null);
        }
        for (Map.Entry<String, Value> it : bindings.entrySet()) {
            bindings.put(it.getKey(), it.getValue().materialize(qc, QueryError.BASEX_FUNCTION_X, this.info));
        }
        QueryJobSpec spec = new QueryJobSpec(opts, bindings, query);
        QueryJob job = new QueryJob(spec, qc.context, this.info, null);
        if (service) {
            if (!bindings.isEmpty()) {
                throw QueryError.JOBS_SERVICE.get(this.info, new Object[0]);
            }
            try {
                Jobs jobs = new Jobs(qc.context);
                jobs.add(spec);
                jobs.write();
            }
            catch (IOException ex) {
                throw QueryError.JOBS_SERVICE_X_X.get(this.info, ex);
            }
        }
        return Str.get(job.jc().id());
    }
}

