/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.DynJavaCall;
import org.basex.query.func.java.JavaEval;
import org.basex.query.value.item.QNm;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

final class DynJavaConstr
extends DynJavaCall {
    private ArrayList<Constructor<?>> constrs;

    DynJavaConstr(Class<?> clazz, String[] types, Expr[] args, StaticContext sc, InputInfo info) {
        super(clazz, types, args, sc, info);
    }

    public boolean init(boolean enforce) throws QueryException {
        int el = this.exprs.length;
        this.constrs = new ArrayList();
        for (Constructor<?> c : this.clazz.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            if (params.length != el || !DynJavaConstr.typesMatch(params, this.types)) continue;
            this.constrs.add(c);
        }
        if (!this.constrs.isEmpty()) {
            return true;
        }
        if (!enforce) {
            return false;
        }
        throw QueryError.JAVACONSTR_X_X.get(this.info, this.name(), el);
    }

    @Override
    protected Object eval(QueryContext qc) throws QueryException {
        JavaEval je = new JavaEval(this, qc);
        Constructor<?> constr = null;
        for (Constructor<?> c : this.constrs) {
            if (!je.match(c.getParameterTypes(), true, null)) continue;
            if (constr != null) {
                throw je.multipleError(QueryError.DYNMULTICONS_X_X);
            }
            constr = c;
        }
        if (constr != null) {
            try {
                return constr.newInstance(je.args);
            }
            catch (Exception ex) {
                throw je.execError(ex);
            }
        }
        throw je.argsError(this.constrs.get(0), this.constrs.size() > 1);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        DynJavaConstr c = new DynJavaConstr(this.clazz, this.types, DynJavaConstr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.sc, this.info);
        c.constrs = this.constrs;
        return this.copyType(c);
    }

    @Override
    String desc() {
        return QNm.eqName("java:" + this.clazz.getName(), "new");
    }

    @Override
    String name() {
        return this.clazz.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynJavaConstr && super.equals(obj);
    }
}

