/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.io.IOException;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.QueryProcessor;
import org.basex.query.ann.Ann;
import org.basex.query.scope.AModule;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTxt;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public abstract class Inspect {
    public static final byte[][] DOC_TAGS = Token.tokens("description", "author", "version", "param", "return", "error", "deprecated", "see", "since");
    public static final byte[] DOC_DESCRIPTION = Token.token("description");
    public static final byte[] DOC_PARAM = Token.token("param");
    public static final byte[] DOC_RETURN = Token.token("return");
    final QueryContext qc;
    final InputInfo info;
    AModule module;

    Inspect(QueryContext qc, InputInfo info) {
        this.qc = qc;
        this.info = info;
    }

    public abstract FElem parse(IO var1) throws QueryException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final QueryParser parseQuery(IO io) throws QueryException {
        try (QueryContext qctx = new QueryContext(this.qc.context);){
            String input = Token.string(io.read());
            QueryParser qp = new QueryParser(input, io.path(), qctx, null);
            this.module = QueryProcessor.isLibrary(input) ? qp.parseLibrary(true) : qp.parseMain();
            QueryParser queryParser = qp;
            return queryParser;
        }
        catch (IOException | QueryException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    final void comment(TokenObjMap<TokenList> tags, FElem parent) {
        for (byte[] tag : tags) {
            for (byte[] name : tags.get(tag)) {
                Inspect.add(name, this.elem(tag, parent));
            }
        }
    }

    final void annotation(AnnList anns, FElem parent, boolean uri) throws QueryException {
        for (Ann ann : anns) {
            FElem annotation = this.elem("annotation", parent);
            QNm name = ann.name();
            annotation.add("name", name.string());
            if (uri) {
                annotation.add("uri", name.uri());
            }
            for (Item arg : ann.args()) {
                this.elem("literal", annotation).add("type", arg.type.toString()).add(arg.string(null));
            }
        }
    }

    protected abstract FElem elem(byte[] var1, FElem var2);

    protected abstract FElem elem(String var1, FElem var2);

    public static void add(byte[] value, FElem elem) {
        try {
            MainOptions mopts = MainOptions.get();
            if (Token.contains(value, 60)) {
                DBNode node = new DBNode(new XMLParser(new IOContent(value), mopts, true));
                for (ANode child : ((ANode)node).childIter()) {
                    elem.add(child.copy(mopts, null));
                }
            } else {
                elem.add(new FTxt(value));
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            elem.add(value);
        }
    }

    public static byte[] doc(TokenObjMap<TokenList> doc, byte[] name) {
        TokenList params;
        TokenList tokenList = params = doc != null ? doc.get(DOC_PARAM) : null;
        if (params != null) {
            block0: for (byte[] param : params) {
                int s;
                int vl = param.length;
                for (int v = s = Token.startsWith(param, 36) ? 1 : 0; v < vl; ++v) {
                    if (!Token.ws(param[v])) continue;
                    if (!Token.eq(Token.substring(param, s, v), name)) continue block0;
                    return Token.trim(Token.substring(param, v + 1, vl));
                }
            }
        }
        return null;
    }
}

