/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.fn.RegEx;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class FnTokenize
extends RegEx {
    private static final byte[] DEFAULT = Token.token("\\s+");
    private static final byte[] SPACE = Token.token(" ");

    @Override
    public Value value(QueryContext qc) throws QueryException {
        byte[] value = this.toZeroToken(this.exprs[0], qc);
        if (this.exprs.length < 2) {
            return StrSeq.get(Token.split(Token.normalize(value), 32));
        }
        Pattern pattern = this.pattern(this.exprs[1], this.exprs.length == 3 ? this.exprs[2] : null, qc, true);
        TokenList tl = new TokenList();
        String string = Token.string(value);
        if (!string.isEmpty()) {
            Matcher matcher = pattern.matcher(string);
            int start = 0;
            while (matcher.find()) {
                tl.add(string.substring(start, matcher.start()));
                start = matcher.end();
            }
            tl.add(string.substring(start));
        }
        return StrSeq.get(tl);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr ptrn;
        Expr expr = this.exprs[0];
        Expr expr2 = ptrn = this.exprs.length == 2 ? this.exprs[1] : null;
        if (Function.NORMALIZE_SPACE.is(expr) && ptrn instanceof Str && Token.eq(((Str)ptrn).string(), SPACE)) {
            Expr arg = expr.args().length == 1 ? expr.arg(0) : ContextValue.get(cc, this.info);
            return cc.function(Function.TOKENIZE, this.info, arg);
        }
        return this;
    }

    public boolean whitespaces() {
        int el = this.exprs.length;
        return el == 1 || el == 2 && this.exprs[1] instanceof Str && Token.eq(((Str)this.exprs[1]).string(), DEFAULT);
    }
}

