/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class FnRemove
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter iter = this.exprs[0].iter(qc);
        final long pos = this.toLong(this.exprs[1], qc);
        final long size = iter.size();
        if (pos <= 0L || size != -1L && pos > size) {
            return iter;
        }
        Value value = iter.iterValue();
        if (value != null) {
            return FnRemove.value(value, pos, qc).iter();
        }
        if (size > 1L) {
            return new Iter(){
                long c;

                @Override
                public Item next() throws QueryException {
                    return ++this.c != pos || iter.next() != null ? qc.next(iter) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(i + 1L < pos ? i : i + 1L);
                }

                @Override
                public long size() {
                    return size - 1L;
                }
            };
        }
        return new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                return ++this.c != pos || iter.next() != null ? qc.next(iter) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return FnRemove.value(this.exprs[0].value(qc), this.toLong(this.exprs[1], qc), qc);
    }

    private static Value value(Value value, long pos, QueryContext qc) {
        long size = value.size();
        if (pos <= 0L || pos > size) {
            return value;
        }
        if (pos == 1L || pos == size) {
            return value.subsequence(pos == 1L ? 1L : 0L, size - 1L, qc);
        }
        return ((Seq)value).remove(pos - 1L, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (this.allAreValues(false)) {
            return this.value(cc.qc);
        }
        Expr expr = this.exprs[0];
        Expr pos = this.exprs[1];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        long sz = -1L;
        if (pos instanceof Value) {
            long p = this.toLong(pos, cc.qc);
            long size = expr.size();
            if (p < 1L || size > 0L && p > size) {
                return expr;
            }
            if (p == 1L) {
                return cc.function(Function.TAIL, this.info, expr);
            }
            if (p == size) {
                return cc.function(Function._UTIL_INIT, this.info, expr);
            }
            --sz;
        }
        this.exprType.assign(st.union(Occ.ZERO), sz);
        this.data(expr.data());
        return this;
    }

    @Override
    public boolean ddo() {
        return this.exprs[0].ddo();
    }
}

