/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;

public final class FnPath
extends ContextFn {
    private static final byte[] ROOT = QNm.eqName(QueryText.FN_URI, Token.token("root()"));
    private final Map<ANode, byte[]> paths = Collections.synchronizedMap(new LinkedHashMap<ANode, byte[]>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ANode, byte[]> eldest) {
            return this.size() > 1000;
        }
    });

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode node = this.toNodeOrNull(this.ctxArg(0, qc), qc);
        if (node == null) {
            return Empty.VALUE;
        }
        TokenBuilder tb = new TokenBuilder();
        TokenList steps = new TokenList();
        ANodeList nodes = new ANodeList();
        while (true) {
            byte[] path;
            if ((path = this.paths.get(node)) != null) {
                tb.add(path);
                break;
            }
            ANode parent = node.parent();
            if (parent == null) {
                if (node.type == NodeType.DOCUMENT_NODE) break;
                tb.add(ROOT);
                break;
            }
            QNm qname = node.qname();
            NodeType type = (NodeType)node.type;
            if (type == NodeType.ATTRIBUTE) {
                tb.add(64).add(qname.id());
            } else if (type == NodeType.ELEMENT) {
                tb.add(qname.eqName()).add(91).addInt(FnPath.element(node, qname, qc)).add(93);
            } else if (type == NodeType.COMMENT || type == NodeType.TEXT) {
                tb.add(type.toString()).add(91).addInt(FnPath.textComment(node, qc)).add(93);
            } else if (type == NodeType.PROCESSING_INSTRUCTION) {
                String name = type.toString(Token.string(qname.local()));
                tb.add(name).add(91).addInt(FnPath.pi(node, qname, qc)).add(93);
            }
            steps.add(tb.next());
            nodes.add(node);
            node = parent;
        }
        for (int s = steps.size() - 1; s >= 0; --s) {
            tb.add(47).add((byte[])steps.get(s));
            node = (ANode)nodes.get(s);
            if (node.type != NodeType.ELEMENT) continue;
            this.paths.put(node, tb.toArray());
        }
        return Str.get(tb.isEmpty() ? Token.SLASH : tb.finish());
    }

    private static int element(ANode node, QNm qname, QueryContext qc) {
        ANode fs;
        int p = 1;
        BasicNodeIter iter = node.precedingSiblingIter();
        while ((fs = iter.next()) != null) {
            qc.checkStop();
            QNm qnm = fs.qname();
            if (qnm == null || !qnm.eq(qname)) continue;
            ++p;
        }
        return p;
    }

    private static int textComment(ANode node, QueryContext qc) {
        ANode fs;
        int p = 1;
        BasicNodeIter iter = node.precedingSiblingIter();
        while ((fs = iter.next()) != null) {
            qc.checkStop();
            if (fs.type != node.type) continue;
            ++p;
        }
        return p;
    }

    private static int pi(ANode node, QNm qname, QueryContext qc) {
        ANode fs;
        BasicNodeIter iter = node.precedingSiblingIter();
        int p = 1;
        while ((fs = iter.next()) != null) {
            qc.checkStop();
            if (fs.type != node.type || !fs.qname().eq(qname)) continue;
            ++p;
        }
        return p;
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optFirst(true, false, cc.qc.focus.value);
    }
}

