/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;

public final class FnInsertBefore
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter iter = this.exprs[0].iter(qc);
        final long pos = this.pos(qc);
        final Iter insert = this.exprs[2].iter(qc);
        return new Iter(){
            long p;
            boolean last;
            {
                this.p = pos;
            }

            @Override
            public Item next() throws QueryException {
                while (!this.last) {
                    boolean sub = this.p == -1L || --this.p == -1L;
                    Item item = qc.next(sub ? insert : iter);
                    if (item != null) {
                        return item;
                    }
                    if (sub) {
                        --this.p;
                        continue;
                    }
                    this.last = true;
                }
                return this.p >= 0L ? insert.next() : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        Value insert = this.exprs[2].value(qc);
        long size = value.size();
        long pos = Math.min(this.pos(qc), size);
        return pos == 0L ? ValueBuilder.concat(insert, value, qc) : (pos == size ? ValueBuilder.concat(value, insert, qc) : ((Seq)value).insertBefore(pos, insert, qc));
    }

    private long pos(QueryContext qc) throws QueryException {
        return Math.max(0L, this.toLong(this.exprs[1], qc) - 1L);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        Expr expr3 = this.exprs[2];
        if (expr1 == Empty.VALUE) {
            return expr3;
        }
        if (expr3 == Empty.VALUE) {
            return expr1;
        }
        SeqType st1 = expr1.seqType();
        SeqType st3 = expr3.seqType();
        long size1 = expr1.size();
        long size3 = expr3.size();
        if (expr2 instanceof Value) {
            long pos = this.pos(cc.qc);
            if (pos == 0L) {
                return List.get(cc, this.info, expr3, expr1);
            }
            if (size1 != -1L && pos >= size1) {
                return List.get(cc, this.info, expr1, expr3);
            }
        }
        long sz = size1 != -1L && size3 != -1L ? size1 + size3 : -1L;
        this.exprType.assign(st1.union(st3), st1.occ.add(st3.occ), sz);
        Data data = expr1.data();
        if (data != null && expr3.data() == data) {
            this.data(data);
        }
        return this;
    }
}

