/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class FnHead
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item = this.exprs[0].iter(qc).next();
        return item == null ? Empty.VALUE : item;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqRange r;
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zeroOrOne()) {
            return expr;
        }
        long size = expr.size();
        if (Function._UTIL_INIT.is(expr) && size > 1L) {
            return cc.function(Function.HEAD, this.info, expr.args());
        }
        if (Function.TAIL.is(expr)) {
            return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), Int.get(2L));
        }
        if ((Function.SUBSEQUENCE.is(expr) || Function._UTIL_RANGE.is(expr)) && (r = SeqRange.get(expr, cc)) != null && r.length != 0L) {
            return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), Int.get(r.start + 1L));
        }
        if (Function.REVERSE.is(expr)) {
            return cc.function(Function._UTIL_LAST, this.info, expr.args());
        }
        if (Function._UTIL_REPLICATE.is(expr) && expr.arg(1) instanceof Int) {
            return cc.function(Function.HEAD, this.info, expr.arg(0));
        }
        if (Function._FILE_READ_TEXT_LINES.is(expr)) {
            return FileReadTextLines.opt(this, 0L, 1L, cc);
        }
        if (expr instanceof List) {
            Expr[] args = expr.args();
            Expr first = args[0];
            SeqType st1 = first.seqType();
            if (st1.one()) {
                return first;
            }
            if (st1.oneOrMore()) {
                return cc.function(Function.HEAD, this.info, first);
            }
            if (st1.zeroOrOne()) {
                Expr dflt = List.get(cc, this.info, Arrays.copyOfRange(args, 1, args.length));
                return cc.function(Function._UTIL_OR, this.info, first, cc.function(Function.HEAD, this.info, dflt));
            }
        }
        this.exprType.assign(st.with(st.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE));
        this.data(expr.data());
        return this;
    }
}

