/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.path.PathNode;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationItemSet;
import org.basex.query.util.hash.HashItemSet;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;

public final class FnDistinctValues
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        Collation coll = this.toCollation(1, qc);
        Expr expr = this.exprs[0];
        final Iter iter = expr.atomIter(qc, this.info);
        final ItemSet set = coll == null ? new HashItemSet(false) : new CollationItemSet(coll);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(iter)) != null) {
                    if (!set.add(item, FnDistinctValues.this.info)) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        this.exprs[0] = this.exprs[0].simplifyFor(CompileContext.Simplify.DATA, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        AtomType type = st.type.atomic();
        if (type != null) {
            this.exprType.assign(type);
            if (this.exprs.length == 1) {
                if (expr instanceof Range || expr instanceof RangeSeq) {
                    return expr;
                }
                if (st.zeroOrOne()) {
                    return type == st.type ? expr : cc.function(Function.DATA, this.info, this.exprs);
                }
            }
        }
        return this.optStats(expr, cc);
    }

    /*
     * WARNING - void declaration
     */
    private Expr optStats(Expr expr, CompileContext cc) throws QueryException {
        if (this.exprs.length > 1 || !(expr instanceof AxisPath)) {
            return this;
        }
        AxisPath path = (AxisPath)expr;
        ArrayList<PathNode> nodes = path.pathNodes(path.root);
        if (nodes == null) {
            return this;
        }
        ValueBuilder vb = new ValueBuilder(cc.qc);
        HashItemSet set = new HashItemSet(false);
        for (PathNode pathNode : nodes) {
            void var8_8;
            if (pathNode.kind == 1) {
                if (!pathNode.stats.isLeaf()) {
                    return this;
                }
                for (PathNode nd : pathNode.children) {
                    if (nd.kind != 2) continue;
                    PathNode pathNode2 = nd;
                }
            }
            if (var8_8.kind != 2 && var8_8.kind != 3) {
                return this;
            }
            if (!StatsType.isCategory(var8_8.stats.type)) {
                return this;
            }
            for (byte[] c : var8_8.stats.values) {
                Atm item = new Atm(c);
                if (!set.add(item, this.info)) continue;
                vb.add(item);
            }
        }
        return vb.value(this);
    }

    public Expr duplicates(CmpV.OpV op, CompileContext cc) throws QueryException {
        if (op == CmpV.OpV.LT) {
            return Bln.FALSE;
        }
        if (op == CmpV.OpV.GE) {
            return Bln.TRUE;
        }
        Expr dupl = cc.function(Function._UTIL_DUPLICATES, this.info, this.exprs);
        return cc.function(op == CmpV.OpV.LE || op == CmpV.OpV.EQ ? Function.EMPTY : Function.EXISTS, this.info, dupl);
    }
}

