/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnCompare
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        long diff;
        byte[] token1 = this.toTokenOrNull(this.exprs[0], qc);
        byte[] token2 = this.toTokenOrNull(this.exprs[1], qc);
        Collation coll = this.toCollation(2, qc);
        if (token1 == null || token2 == null) {
            return Empty.VALUE;
        }
        long l = diff = coll == null ? (long)Token.diff(token1, token2) : (long)coll.compare(token1, token2);
        return Int.get(diff < 0L ? -1L : (diff > 0L ? 1L : 0L));
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        if (st1.zero()) {
            return expr1;
        }
        if (st2.zero()) {
            return expr2;
        }
        if (st1.oneOrMore() && !st1.mayBeArray() && st2.oneOrMore() && !st2.mayBeArray()) {
            this.exprType.assign(Occ.EXACTLY_ONE);
        }
        return this;
    }
}

