/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.EnumSet;
import java.util.Stack;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class DeepEqual {
    private final InputInfo info;
    private final EnumSet<Mode> flags = EnumSet.noneOf(Mode.class);
    private Collation coll;

    public DeepEqual() {
        this(null);
    }

    public DeepEqual(InputInfo info) {
        this.info = info;
    }

    public DeepEqual flag(Mode flag) {
        this.flags.add(flag);
        return this;
    }

    public DeepEqual collation(Collation cl) {
        this.coll = cl;
        return this;
    }

    public boolean equal(Value value1, Value value2) throws QueryException {
        return this.equal(value1.iter(), value2.iter());
    }

    public boolean equal(Iter iter1, Iter iter2) throws QueryException {
        return this.equal(iter1, iter2, null);
    }

    public boolean equal(Iter iter1, Iter iter2, QueryContext qc) throws QueryException {
        long size1 = iter1.size();
        long size2 = iter2.size();
        if (size1 != -1L && size2 != -1L && size1 != size2) {
            return false;
        }
        while (true) {
            if (qc != null) {
                qc.checkStop();
            }
            Item item1 = iter1.next();
            Item item2 = iter2.next();
            if (item1 == null || item2 == null) {
                return item1 == null && item2 == null;
            }
            if (item1 instanceof FItem) {
                if (((FItem)item1).deep(item2, this.coll, this.info)) continue;
                return false;
            }
            if (item2 instanceof FItem) {
                if (((FItem)item2).deep(item1, this.coll, this.info)) continue;
                return false;
            }
            if (item1 == item2) continue;
            if (!(item1 instanceof ANode) && !(item2 instanceof ANode)) {
                if (item1.equiv(item2, this.coll, this.info)) continue;
                return false;
            }
            Type type1 = item1.type;
            Type type2 = item2.type;
            if (type1 != type2) {
                return false;
            }
            ANode node1 = (ANode)item1;
            ANode node2 = (ANode)item2;
            if (node1.is(node2)) continue;
            BasicNodeIter ch1 = node1.childIter();
            BasicNodeIter ch2 = node2.childIter();
            Stack<BasicNodeIter> stack = new Stack<BasicNodeIter>();
            stack.push(ch1);
            stack.push(ch2);
            boolean skip = false;
            do {
                type1 = node1 != null ? node1.type : null;
                Type type = type2 = node2 != null ? node2.type : null;
                if (skip) {
                    if (type1 == NodeType.COMMENT || type1 == NodeType.PROCESSING_INSTRUCTION) {
                        node1 = ch1.next();
                        continue;
                    }
                    if (type2 == NodeType.COMMENT || type2 == NodeType.PROCESSING_INSTRUCTION) {
                        node2 = ch2.next();
                        continue;
                    }
                }
                if (node1 == null || node2 == null) {
                    if (node1 != node2) {
                        return false;
                    }
                    ch2 = (BasicNodeIter)stack.pop();
                    ch1 = (BasicNodeIter)stack.pop();
                } else {
                    if (type1 != type2) {
                        return false;
                    }
                    QNm n1 = node1.qname();
                    QNm n2 = node2.qname();
                    if (n1 != null && (!n1.eq(n2) || this.flags.contains((Object)Mode.NAMESPACES) && !Token.eq(n1.prefix(), n2.prefix()))) {
                        return false;
                    }
                    if (type1 == NodeType.TEXT || type1 == NodeType.ATTRIBUTE || type1 == NodeType.COMMENT || type1 == NodeType.PROCESSING_INSTRUCTION || type1 == NodeType.NAMESPACE_NODE) {
                        if (!Token.eq(node1.string(), node2.string())) {
                            return false;
                        }
                    } else if (type1 == NodeType.ELEMENT) {
                        ANode a1;
                        BasicNodeIter ir1 = node1.attributeIter();
                        BasicNodeIter ir2 = node2.attributeIter();
                        if (ir1.size() != ir2.size()) {
                            return false;
                        }
                        block2: while ((a1 = ir1.next()) != null) {
                            ANode a2;
                            n1 = a1.qname();
                            while ((a2 = ir2.next()) != null) {
                                n2 = a2.qname();
                                if (!n1.eq(n2)) continue;
                                if (this.flags.contains((Object)Mode.NAMESPACES) && !Token.eq(n1.prefix(), n2.prefix()) || !Token.eq(a1.string(), a2.string())) {
                                    return false;
                                }
                                ir2 = node2.attributeIter();
                                continue block2;
                            }
                            return false;
                        }
                        if (this.flags.contains((Object)Mode.NAMESPACES)) {
                            int nl2;
                            Atts ns1 = node1.namespaces();
                            Atts ns2 = node2.namespaces();
                            int nl1 = ns1.size();
                            if (nl1 != (nl2 = ns2.size())) {
                                return false;
                            }
                            block4: for (int i1 = 0; i1 < nl1; ++i1) {
                                for (int i2 = 0; i2 < nl2; ++i2) {
                                    if (!Token.eq(ns1.name(i1), ns2.name(i2))) continue;
                                    if (Token.eq(ns1.value(i1), ns2.value(i2))) continue block4;
                                    return false;
                                }
                                return false;
                            }
                        }
                        stack.push(ch1);
                        stack.push(ch2);
                        ch1 = node1.childIter();
                        ch2 = node2.childIter();
                    }
                }
                node1 = ch1.next();
                node2 = ch2.next();
                boolean bl = skip = !this.flags.contains((Object)Mode.ALLNODES);
            } while (!stack.isEmpty());
        }
    }

    public static enum Mode {
        ALLNODES,
        NAMESPACES;

    }
}

