/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.basex.io.in.BufferInput;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.util.Token;

public class FileWriteText
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        block26: {
            Path path = this.checkParentDir(this.toPath(0, qc));
            AStr text = (AStr)this.checkType(this.exprs[1], qc, AtomType.STRING);
            String encoding = this.toEncodingOrNull(2, QueryError.FILE_UNKNOWN_ENCODING_X, qc);
            Charset cs = encoding == null || encoding == "UTF-8" ? null : Charset.forName(encoding);
            try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));){
                if (cs == null) {
                    try (BufferInput in = text.input(this.info);){
                        int b;
                        while ((b = in.read()) != -1) {
                            out.write(b);
                        }
                        break block26;
                    }
                }
                out.write(Token.string(text.string(this.info)).getBytes(cs));
            }
        }
    }
}

