/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.cmd.Get;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class DbOption
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] name = this.toToken(this.exprs[0], qc);
        Object value = Get.get(Token.string(Token.uc(name)), qc.context);
        if (value == null) {
            throw QueryError.DB_OPTION_X.get(this.info, new Object[]{name});
        }
        return this.item(value);
    }

    private Item item(Object value) throws QueryException {
        if (value == null) {
            return Empty.VALUE;
        }
        if (value instanceof Boolean) {
            return Bln.get((Boolean)value);
        }
        if (value instanceof Integer) {
            return Int.get(((Integer)value).intValue());
        }
        if (value instanceof Options) {
            XQMap map = XQMap.EMPTY;
            Options opts = (Options)value;
            for (Option<?> opt : opts) {
                Item item = this.item(opt.value());
                if (item == null) continue;
                map = map.put(Str.get(opt.name()), item, this.info);
            }
            return map;
        }
        return Str.get(value.toString());
    }
}

