/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Date;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class DbList
extends StandardFunc {
    static final String DATABASE = "database";
    static final String RESOURCE = "resource";
    static final String RESOURCES = "resources";
    static final String PATH = "path";
    static final String RAW = "raw";
    static final String SIZE = "size";
    static final String CONTENT_TYPE = "content-type";
    static final String MODIFIED_DATE = "modified-date";
    static final String DIR = "dir";

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.exprs.length == 0 ? DbList.list(qc).iter() : this.resources(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.exprs.length == 0 ? DbList.list(qc) : this.resources(qc).value(qc, this);
    }

    private static Value list(QueryContext qc) {
        Context ctx = qc.context;
        StringList dbs = ctx.listDBs();
        TokenList list = new TokenList(dbs.size());
        for (String name : dbs) {
            list.add(name);
        }
        return StrSeq.get(list);
    }

    private Iter resources(QueryContext qc) throws QueryException {
        final Data data = this.checkData(qc);
        String path = Token.string(this.exprs.length == 1 ? Token.EMPTY : this.toToken(this.exprs[1], qc));
        final IntList docs = data.resources.docs(path);
        final TokenList bins = data.resources.binaries(path);
        final int ds = docs.size();
        int size = ds + bins.size();
        return new BasicIter<Str>((long)size){

            @Override
            public Str get(long i) {
                return i < this.size ? Str.get(this.tokenAt((int)i)) : null;
            }

            @Override
            public Value value(QueryContext q, Expr expr) throws QueryException {
                TokenList tl = new TokenList(Seq.initialCapacity(this.size));
                int i = 0;
                while ((long)i < this.size) {
                    tl.add(this.tokenAt(i));
                    ++i;
                }
                return StrSeq.get(tl);
            }

            private byte[] tokenAt(int i) {
                return i < ds ? data.text(docs.get(i), true) : (byte[])bins.get(i - ds);
            }
        };
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        if (this.exprs.length == 0 ? !visitor.lock(null, false) : !this.dataLock(visitor, 0)) {
            return false;
        }
        return super.accept(visitor);
    }

    static FNode dir(byte[] path, long mdate) {
        FElem dir = new FElem(DIR);
        dir.add(path).add(MODIFIED_DATE, DateTime.format(new Date(mdate)));
        return dir;
    }

    static FNode resource(byte[] path, boolean raw, MediaType type, long mdate, Long size) {
        FElem resource = new FElem(RESOURCE).add(path);
        resource.add(RAW, Token.token(raw));
        resource.add(CONTENT_TYPE, type.toString());
        resource.add(MODIFIED_DATE, DateTime.format(new Date(mdate)));
        if (size != null) {
            resource.add(SIZE, Token.token(size));
        }
        return resource;
    }
}

