/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.convert;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ConvertFn
extends StandardFunc {
    final byte[] stringToBinary(QueryContext qc) throws QueryException {
        byte[] token = this.toToken(this.exprs[0], qc);
        String encoding = this.toEncodingOrNull(1, QueryError.CONVERT_ENCODING_X, qc);
        if (encoding == null || encoding == "UTF-8") {
            return token;
        }
        try {
            return ConvertFn.toBinary(token, encoding);
        }
        catch (CharacterCodingException ex) {
            Util.debug(ex);
            throw QueryError.CONVERT_BINARY_X_X.get(this.info, QueryError.normalize(token, this.info), encoding);
        }
    }

    public static byte[] toBinary(byte[] in, String enc) throws CharacterCodingException {
        if (enc == "UTF-8") {
            return in;
        }
        ByteBuffer bb = Charset.forName(enc).newEncoder().encode(CharBuffer.wrap(Token.string(in)));
        int il = bb.limit();
        byte[] tmp = bb.array();
        return tmp.length == il ? tmp : Arrays.copyOf(tmp, il);
    }

    public static byte[] toString(InputStream is, String encoding, boolean validate) throws IOException {
        try (TextInput ti = new TextInput(is);){
            byte[] byArray = ti.encoding(encoding).validate(validate).content();
            return byArray;
        }
    }
}

