/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import org.basex.core.MainOptions;
import org.basex.core.locks.Locking;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.StaticFuncs;
import org.basex.query.func.XQFunction;
import org.basex.query.scope.Scope;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class StaticFunc
extends StaticDecl
implements XQFunction {
    public final Var[] params;
    final boolean updating;
    private final EnumMap<Flag, Boolean> map = new EnumMap(Flag.class);
    private boolean compiling;

    StaticFunc(AnnList anns, QNm name, Var[] params, SeqType type, Expr expr, String doc, VarScope vs, InputInfo info) {
        super(anns, name, type, vs, doc, info);
        this.params = params;
        this.expr = expr;
        this.updating = anns.contains(Annotation.UPDATING);
    }

    @Override
    public void comp(CompileContext cc) {
        if (this.compiled || this.expr == null) {
            return;
        }
        this.compiled = true;
        this.compiling = true;
        cc.pushFocus(null);
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
            if (this.declType != null) {
                this.expr = new TypeCheck(this.sc, this.info, this.expr, this.declType, true).optimize(cc);
            }
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        finally {
            cc.removeScope(this);
            cc.removeFocus();
        }
        this.expr.markTailCalls(cc);
        this.compiling = false;
    }

    public void optimize(CompileContext cc) {
        SeqType[] seqTypes = cc.qc.funcs.seqTypes(this);
        if (seqTypes != null) {
            int pl = this.arity();
            for (int p = 0; p < pl; ++p) {
                if (!seqTypes[p].instanceOf(this.params[p].seqType())) continue;
                cc.info("remove type check: %", this.params[p]);
                this.params[p].declType = null;
            }
        }
        this.declType = null;
    }

    private boolean selfRecursive() {
        return !this.expr.accept(new ASTVisitor(){

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return call.func != StaticFunc.this;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }
        });
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.anns, this.declType, this.params);
    }

    @Override
    public int stackFrameSize() {
        return this.vs.stackSize();
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        qf.value = null;
        try {
            int pl = this.params.length;
            for (int p = 0; p < pl; ++p) {
                qc.set(this.params[p], args[p]);
            }
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            qf.value = cv;
        }
    }

    void checkUp() throws QueryException {
        InputInfo ii;
        boolean upd = this.expr.has(Flag.UPD);
        if (upd) {
            this.expr.checkUp();
        }
        InputInfo inputInfo = ii = this.expr instanceof ParseExpr ? ((ParseExpr)this.expr).info : this.info;
        if (this.updating) {
            if (this.declType != null && !this.declType.zero()) {
                throw QueryError.UUPFUNCTYPE.get(this.info, new Object[0]);
            }
            if (!upd && !this.expr.vacuous()) {
                throw QueryError.UPEXPECTF.get(ii, new Object[0]);
            }
        } else if (upd) {
            throw QueryError.UPNOT_X.get(ii, this.description());
        }
    }

    @Override
    public boolean vacuousBody() {
        return this.declType != null && this.declType.zero() && !this.has(Flag.UPD);
    }

    boolean has(Flag ... flags) {
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && this.check(flgs);
    }

    boolean updating() {
        return this.sc.mixUpdates ? this.check(Flag.UPD) : this.updating;
    }

    private boolean check(Flag ... flags) {
        ArrayList<Flag> flgs = new ArrayList<Flag>();
        for (Object flag : flags) {
            if (this.map.containsKey(flag)) continue;
            this.map.put((Flag)((Object)flag), false);
            flgs.add((Flag)((Object)flag));
        }
        for (Flag flag : flgs) {
            this.map.put(flag, this.expr.has(flag));
        }
        for (Object flag : flags) {
            if (!this.map.get(flag).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Ann ann : this.anns) {
            if (ann.sig != Annotation._BASEX_LOCK) continue;
            for (Item arg : ann.args()) {
                for (String lock : Locking.queryLocks(((Str)arg).string())) {
                    visitor.lock(lock, false);
                }
            }
        }
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr == null || this.expr.accept(visitor);
    }

    @Override
    public byte[] id() {
        return StaticFuncs.signature(this.name, this.params.length);
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) throws QueryException {
        if (!StaticFunc.inline(cc, this.anns, this.expr) || this.has(Flag.CTX) || this.compiling || this.selfRecursive()) {
            return null;
        }
        cc.info("inline %", this::id);
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        IntObjMap<Var> vm = new IntObjMap<Var>();
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p]).optimize(cc));
        }
        Expr rtrn = this.expr.copy(cc, vm).optimize(cc);
        return clauses.isEmpty() ? rtrn : new GFLWOR(this.info, clauses, rtrn).optimize(cc);
    }

    public static boolean inline(CompileContext cc, AnnList anns, Expr expr) {
        Item[] args;
        Ann ann = anns.get(Annotation._BASEX_INLINE);
        long limit = ann == null ? (long)cc.qc.context.options.get(MainOptions.INLINELIMIT).intValue() : ((args = ann.args()).length > 0 ? ((ANum)args[0]).itr() : Long.MAX_VALUE);
        return (long)expr.exprSize() < limit;
    }

    @Override
    public String description() {
        return "function declaration";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string()), new Object[]{this.params, this.expr});
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("declare").token(this.anns).token("function").token(this.name.prefixId()).params(this.params);
        if (this.declType != null) {
            qs.token("as").token(this.declType);
        }
        if (this.expr != null) {
            qs.brace(this.expr);
        } else {
            qs.token("external");
        }
        qs.token(';');
    }
}

