/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Eval;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.ForLet;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class Let
extends ForLet {
    public Let(Var var, Expr expr) {
        this(var, expr, false);
    }

    public Let(Var var, Expr expr, boolean scoring) {
        super(var.info, scoring ? SeqType.DOUBLE_O : SeqType.ITEM_ZM, var, expr, scoring, var);
    }

    static Let fromFor(For fr) {
        Let lt = new Let(fr.var, fr.expr);
        lt.adoptType(fr.expr);
        return lt;
    }

    static Let fromForScore(For fr) {
        VarRef varRef = new VarRef(fr.info, fr.var);
        return new Let(fr.score, varRef, true);
    }

    @Override
    LetEval eval(Eval sub) {
        if (!(sub instanceof LetEval)) {
            return new LetEval(this, sub);
        }
        LetEval eval = (LetEval)sub;
        eval.lets.add(this);
        return eval;
    }

    private static Dbl score(Iter iter, QueryContext qc) throws QueryException {
        Item item;
        double score = 0.0;
        int c = 0;
        while ((item = qc.next(iter)) != null) {
            score += item.score();
            ++c;
        }
        return Dbl.get(Scoring.avg(score, c));
    }

    @Override
    public Let optimize(CompileContext cc) throws QueryException {
        TypeCheck tc;
        if (!this.scoring && this.expr instanceof TypeCheck && ((tc = (TypeCheck)this.expr).isRedundant(this.var) || this.var.adoptCheck(tc.seqType(), tc.promote))) {
            cc.info("remove type check: %", this);
            this.expr = tc.expr;
        }
        if (this.expr instanceof Value) {
            this.expr = this.var.checkType((Value)this.expr, cc.qc, true);
        }
        if (this.scoring) {
            this.var.expr(Dbl.ZERO);
        } else {
            this.adoptType(this.expr);
            this.var.expr(this.expr);
        }
        this.var.refineType(this.seqType(), this.size(), cc);
        return this;
    }

    @Override
    public Let copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Let(cc.copy(this.var, vm), this.expr.copy(cc, vm), this.scoring));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && visitor.declared(this.var);
    }

    @Override
    Expr inlineExpr(CompileContext cc) throws QueryException {
        return this.scoring ? null : this.var.checked(this.expr, cc);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Let && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        FElem elem = plan.attachVariable(plan.create(this, new Object[0]), this.var, false);
        if (this.scoring) {
            plan.addAttribute(elem, "score", true);
        }
        plan.add(elem, this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("let");
        if (this.scoring) {
            qs.token("score");
        }
        qs.token(this.var).token(":=").token(this.expr);
    }

    private static class LetEval
    extends Eval {
        private final ArrayList<Let> lets = new ArrayList();
        private final Eval sub;

        LetEval(Let let, Eval sub) {
            this.lets.add(let);
            this.sub = sub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean next(QueryContext qc) throws QueryException {
            if (!this.sub.next(qc)) {
                return false;
            }
            for (Let let : this.lets) {
                Value vl;
                if (let.scoring) {
                    boolean s = qc.scoring;
                    try {
                        qc.scoring = true;
                        vl = Let.score(let.expr.iter(qc), qc);
                    }
                    finally {
                        qc.scoring = s;
                    }
                } else {
                    vl = let.expr.value(qc);
                }
                qc.set(let.var, vl);
            }
            return true;
        }
    }
}

