/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class ForLet
extends Clause {
    public Var var;
    public Expr expr;
    boolean scoring;

    ForLet(InputInfo info, SeqType seqType, Var var, Expr expr, boolean scoring, Var ... vars) {
        super(info, seqType, vars);
        this.var = var;
        this.expr = expr;
        this.scoring = scoring;
    }

    @Override
    public final Clause compile(CompileContext cc) throws QueryException {
        this.expr = this.expr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public final boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public final boolean inlineable(InlineContext v) {
        return this.expr.inlineable(v);
    }

    @Override
    public final VarUsage count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public final Clause inline(InlineContext ic) throws QueryException {
        Expr inlined = this.expr.inline(ic);
        if (inlined == null) {
            return null;
        }
        this.expr = inlined;
        return this.optimize(ic.cc);
    }

    abstract Expr inlineExpr(CompileContext var1) throws QueryException;

    final boolean toPredicate(CompileContext cc, Expr ex) throws QueryException {
        if (this.vars.length != 1 || this.scoring || this.var.checksType() || this.size() != 1L || !ex.uses(this.var)) {
            return false;
        }
        InlineContext ic = new InlineContext(this.var, new ContextValue(this.info), cc);
        if (!ic.inlineable(ex)) {
            return false;
        }
        Expr pred = cc.get(this.expr, () -> ic.inline(ex));
        if (pred.seqType().mayBeNumber()) {
            pred = cc.function(Function.BOOLEAN, this.info, pred);
        }
        this.addPredicate(cc, pred);
        return true;
    }

    final void addPredicate(CompileContext cc, Expr ex) throws QueryException {
        this.expr = this.expr instanceof AxisPath && !ex.has(Flag.POS) ? ((AxisPath)this.expr).addPredicates(cc, ex) : (this.expr instanceof Filter ? ((Filter)this.expr).addPredicate(cc, ex) : Filter.get(cc, this.info, this.expr, ex));
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public final int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ForLet)) {
            return false;
        }
        ForLet fl = (ForLet)obj;
        return this.expr.equals(fl.expr) && this.var.equals(fl.var) && this.scoring == fl.scoring;
    }
}

