/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.io.IO;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

public final class Thesaurus {
    private final TokenObjMap<ThesNode> nodes = new TokenObjMap();
    private static final TokenMap RSHIPS = new TokenMap();
    private final Context ctx;
    private final IO file;
    private final byte[] rel;
    private final long min;
    private final long max;

    public Thesaurus(IO file, Context ctx) {
        this(file, Token.EMPTY, 0L, Long.MAX_VALUE, ctx);
    }

    public Thesaurus(IO file, byte[] res, long min, long max, Context ctx) {
        this.file = file;
        this.rel = res;
        this.min = min;
        this.max = Math.min(max, min + 100L);
        this.ctx = ctx;
    }

    private void init(InputInfo ii) throws QueryException {
        try {
            Value entries = this.nodes("//*:entry", new DBNode(this.file));
            for (Item entry : entries) {
                this.build(entry);
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw QueryError.NOTHES_X.get(ii, this.file);
        }
    }

    private void build(Value value) throws QueryException {
        Value synonyms = this.nodes("*:synonym", value);
        if (synonyms.isEmpty()) {
            return;
        }
        ThesNode term = this.node(this.text("*:term", value));
        for (Item synonym : synonyms) {
            ThesNode sterm = this.node(this.text("*:term", synonym));
            byte[] rs = this.text("*:relationship", synonym);
            term.add(sterm, rs);
            byte[] srs = RSHIPS.get(rs);
            if (srs != null) {
                sterm.add(term, srs);
            }
            this.build(synonyms);
        }
    }

    private ThesNode node(byte[] term) {
        return this.nodes.computeIfAbsent(term, () -> new ThesNode(term));
    }

    private Value nodes(String query, Value value) throws QueryException {
        try (QueryProcessor qp = new QueryProcessor(query, this.ctx).context(value);){
            Value value2 = qp.value();
            return value2;
        }
    }

    private byte[] text(String query, Value value) throws QueryException {
        try (QueryProcessor qp = new QueryProcessor(query, this.ctx).context(value);){
            byte[] byArray = qp.iter().next().string(null);
            return byArray;
        }
    }

    void find(InputInfo ii, TokenList list, byte[] token) throws QueryException {
        ThesNode tn;
        if (this.nodes.isEmpty()) {
            this.init(ii);
        }
        if ((tn = this.nodes.get(token)) != null) {
            this.find(list, tn, 1L);
        }
    }

    private void find(TokenList list, ThesNode node, long level) {
        for (int n = 0; n < node.size; ++n) {
            ThesNode tn;
            byte[] term;
            if (this.rel.length != 0 && !Token.eq(node.rs[n], this.rel) || list.contains(term = (tn = node.nodes[n]).term)) continue;
            list.add(term);
            if (level >= this.max) continue;
            this.find(list, tn, level + 1L);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Thesaurus)) {
            return false;
        }
        Thesaurus th = (Thesaurus)obj;
        return this.file.eq(th.file) && this.min == th.min && this.max == th.max && Token.eq(this.rel, th.rel);
    }

    static {
        RSHIPS.put("NT", "BT");
        RSHIPS.put("BT", "BT");
        RSHIPS.put("BTG", "NTG");
        RSHIPS.put("NTG", "BTG");
        RSHIPS.put("BTP", "NTP");
        RSHIPS.put("NTP", "BTP");
        RSHIPS.put("USE", "UF");
        RSHIPS.put("UF", "USE");
        RSHIPS.put("RT", "RT");
    }

    private static final class ThesNode {
        private ThesNode[] nodes = new ThesNode[1];
        private byte[][] rs = new byte[1][];
        private final byte[] term;
        private int size;

        private ThesNode(byte[] term) {
            this.term = term;
        }

        private void add(ThesNode n, byte[] r) {
            if (this.size == this.nodes.length) {
                int s = Array.newCapacity(this.size);
                this.nodes = Array.copy(this.nodes, new ThesNode[s]);
                this.rs = Array.copyOf(this.rs, s);
            }
            this.nodes[this.size] = n;
            this.rs[this.size++] = r;
        }
    }
}

