/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class FTWeight
extends FTExpr {
    private Expr weight;

    public FTWeight(InputInfo info, FTExpr expr, Expr weight) {
        super(info, expr);
        this.weight = weight;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.weight);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.weight = this.weight.compile(cc);
        return super.compile(cc).optimize(cc);
    }

    @Override
    public FTExpr optimize(CompileContext cc) throws QueryException {
        this.weight = this.weight.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.weight(this.exprs[0].item(qc, this.info), qc);
    }

    @Override
    public FTIter iter(final QueryContext qc) {
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                FTNode node = FTWeight.this.exprs[0].iter(qc).next();
                return node == null ? null : FTWeight.this.weight(node, qc);
            }
        };
    }

    private FTNode weight(FTNode item, QueryContext qc) throws QueryException {
        double d = this.toDouble(this.weight, qc);
        if (Math.abs(d) > 1000.0) {
            throw QueryError.FTWEIGHT_X.get(this.info, d);
        }
        if (d == 0.0) {
            item.matches().reset();
        }
        item.score(item.score() * d);
        return item;
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) {
        return false;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.weight.has(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.weight.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.weight.count(var).plus(super.count(var));
    }

    @Override
    public FTExpr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.exprs);
        Expr inlined = this.weight.inline(ic);
        if (inlined != null) {
            this.weight = inlined;
            changed = true;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTWeight(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.weight.copy(cc, vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.weight.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (FTExpr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.weight.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTWeight && this.weight.equals(((FTWeight)obj).weight) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.weight, this.exprs[0]);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.exprs[0]).token("weight").brace(this.weight);
    }
}

