/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTIndexAccess;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTContains
extends Single {
    public FTExpr ftexpr;

    public FTContains(Expr expr, FTExpr ftexpr, InputInfo info) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.ftexpr = ftexpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        FTLexer lexer;
        boolean scoring = qc.scoring;
        Iter iter = this.expr.iter(qc);
        FTLexer tmp = qc.ftLexer;
        qc.ftLexer = lexer = new FTLexer(new FTOpt());
        try {
            Item item;
            double score = 0.0;
            int count = 0;
            boolean found = false;
            FTPosData ftPosData = qc.ftPosData;
            while ((item = qc.next(iter)) != null) {
                lexer.init(item.string(this.info));
                FTNode it = this.ftexpr.item(qc, this.info);
                FTMatches all = it.matches();
                if (all.matches()) {
                    found = true;
                    if (scoring) {
                        score += it.score();
                    }
                    if (ftPosData != null && item instanceof DBNode) {
                        DBNode node = (DBNode)item;
                        ftPosData.add(node.data(), node.pre(), all);
                    }
                }
                ++count;
            }
            Bln bln = found && scoring ? Bln.get(Scoring.avg(score, count)) : Bln.get(found);
            return bln;
        }
        finally {
            qc.ftLexer = tmp;
        }
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        this.ftexpr = this.ftexpr.compile(cc);
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        return this.expr.seqType().zero() ? cc.function(Function.BOOLEAN, this.info, this.expr) : this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return super.has(flags) || this.ftexpr.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return super.inlineable(ic) && this.ftexpr.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return super.count(var).plus(this.ftexpr.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        FTExpr ftinlined;
        Expr inlined = this.expr.inline(ic);
        if (inlined != null) {
            this.expr = inlined;
        }
        if ((ftinlined = this.ftexpr.inline(ic)) != null) {
            this.ftexpr = ftinlined;
        }
        return inlined != null || ftinlined != null ? this.optimize(ic.cc) : null;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.ftexpr.accept(visitor);
    }

    @Override
    public int exprSize() {
        return super.exprSize() + this.ftexpr.exprSize();
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexType type = ii.type(this.expr, IndexType.FULLTEXT);
        if (type == null || !this.ftexpr.indexAccessible(ii)) {
            return false;
        }
        ii.create(new FTIndexAccess(this.info, this.ftexpr, ii.db), true, Util.info("apply % index for %", "full-text", this.ftexpr), this.info);
        return true;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTContains(this.expr.copy(cc, vm), (FTExpr)this.ftexpr.copy(cc, (IntObjMap)vm), this.info));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTContains && this.ftexpr.equals(((FTContains)obj).ftexpr) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.expr, this.ftexpr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.expr).token("contains").token("text").token(this.ftexpr);
    }
}

