/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public final class CPI
extends CName {
    public CPI(StaticContext sc, InputInfo info, boolean computed, Expr name, Expr value) {
        super(sc, info, SeqType.PROCESSING_INSTRUCTION_O, computed, name, new Expr[]{value});
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        byte[] nm;
        this.name = this.name.simplifyFor(CompileContext.Simplify.STRING, cc);
        if (this.name instanceof Value && (nm = this.ncname(false, cc.qc)) != null) {
            this.name = Str.get(nm);
            this.exprType.assign(SeqType.get(NodeType.PROCESSING_INSTRUCTION, Occ.EXACTLY_ONE, Test.get(NodeType.PROCESSING_INSTRUCTION, new QNm(nm))));
        }
        this.optValue(cc);
        return this;
    }

    @Override
    public FPI item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] nm = this.ncname(false, qc);
        if (Token.eq(Token.lc(nm), Token.XML)) {
            throw QueryError.CPIXML_X.get(this.info, new Object[]{nm});
        }
        if (!XMLToken.isNCName(nm)) {
            throw QueryError.CPIINVAL_X.get(this.info, new Object[]{nm});
        }
        byte[] value = this.atomValue(qc);
        int i = -1;
        int vl = value.length;
        while (++i < vl && value[i] >= 0 && value[i] <= 32) {
        }
        value = Token.substring(value, i);
        return new FPI(new QNm(nm), FPI.parse(value, this.info));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CPI(this.sc, this.info, this.computed, this.name.copy(cc, vm), this.exprs[0].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CPI && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.computed) {
            this.plan(qs, "processing-instruction");
        } else {
            qs.concat(FPI.OPEN, ((Str)this.name).string(), " ", QueryString.toValue(((Str)this.exprs[0]).string()), FPI.CLOSE);
        }
    }
}

