/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.TokenBuilder;

public abstract class CNode
extends Arr {
    final StaticContext sc;
    final boolean computed;

    CNode(StaticContext sc, InputInfo info, SeqType seqType, boolean computed, Expr ... exprs) {
        super(info, seqType, exprs);
        this.sc = sc;
        this.computed = computed;
    }

    @Override
    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    byte[] atomValue(QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        if (el == 0) {
            return null;
        }
        if (el == 1 && this.exprs[0] instanceof Str) {
            return ((Str)this.exprs[0]).string();
        }
        boolean more = false;
        TokenBuilder tb = new TokenBuilder();
        for (Expr expr : this.exprs) {
            Item item;
            more = false;
            Iter iter = expr.atomIter(qc, this.info);
            while ((item = qc.next(iter)) != null) {
                if (more) {
                    tb.add(32);
                }
                tb.add(item.string(this.info));
                more = true;
            }
        }
        return more ? tb.finish() : null;
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.CNS.in(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return !ic.expr.has(Flag.CNS) && super.inlineable(ic);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CNode && this.computed == ((CNode)obj).computed && super.equals(obj);
    }

    @Override
    public final String description() {
        return Strings.concat(((NodeType)this.seqType().type).qname().local(), " constructor");
    }

    protected void plan(QueryString qs, String kind) {
        if (kind != null) {
            qs.token(kind);
        }
        qs.token("{");
        if (this.exprs.length > 0) {
            qs.tokens(this.exprs, ", ", false);
        }
        qs.token(" }");
    }
}

