/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CNode;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;

abstract class CName
extends CNode {
    Expr name;

    CName(StaticContext sc, InputInfo info, SeqType seqType, boolean computed, Expr name, Expr ... cont) {
        super(sc, info, seqType, computed, cont);
        this.name = name;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.name);
        super.checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.name = this.name.compile(cc);
        return super.compile(cc);
    }

    final void optValue(CompileContext cc) throws QueryException {
        this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.allAreValues(true) && (this.exprs.length != 1 || !(this.exprs[0] instanceof Str))) {
            this.exprs = new Expr[]{Str.get(this.atomValue(cc.qc))};
        }
    }

    @Override
    final byte[] atomValue(QueryContext qc) throws QueryException {
        byte[] value = super.atomValue(qc);
        return value != null ? value : Token.EMPTY;
    }

    final QNm qname(boolean elem, QueryContext qc, StaticContext sctx) throws QueryException {
        Item item = this.checkNoEmpty(this.name.atomItem(qc, this.info), AtomType.QNAME);
        Type type = item.type;
        if (type == AtomType.QNAME) {
            return (QNm)item;
        }
        if (!type.isStringOrUntyped() || type == AtomType.ANY_URI) {
            throw QueryError.STRQNM_X_X.get(this.info, type, item);
        }
        byte[] token = Token.normalize(item.string(this.info));
        if (XMLToken.isQName(token)) {
            return !elem && !Token.contains(token, 58) ? new QNm(token) : (sctx != null ? new QNm(token, sctx) : null);
        }
        String string = Token.string(token);
        if (string.matches("^Q\\{.*\\}.+")) {
            byte[] local = Token.token(string.replaceAll("^.*?\\}", ""));
            byte[] uri = Token.normalize(Token.token(string.replaceAll("^Q\\{|\\}.*", "")));
            if (XMLToken.isNCName(local) && !Token.eq(uri, QueryText.XMLNS_URI) && !Token.contains(uri, 123)) {
                return new QNm(local, uri);
            }
        }
        throw QueryError.INVNAME_X.get(this.info, new Object[]{token});
    }

    final byte[] ncname(boolean empty, QueryContext qc) throws QueryException {
        Item item = this.name.atomItem(qc, this.info);
        if (item != Empty.VALUE) {
            Type type = item.type;
            if (type.isStringOrUntyped() && type != AtomType.ANY_URI) {
                return Token.trim(item.string(this.info));
            }
            throw QueryError.STRNCN_X_X.get(this.info, type, item);
        }
        if (empty) {
            return Token.EMPTY;
        }
        throw QueryError.STRNCN_X_X.get(this.info, SeqType.EMPTY_SEQUENCE_Z, item);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.name.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public final boolean has(Flag ... flags) {
        return this.name.has(flags) || super.has(flags);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.name.accept(visitor) && CName.visitAll(visitor, this.exprs);
    }

    @Override
    public final VarUsage count(Var var) {
        return this.name.count(var).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.exprs);
        Expr inlined = this.name.inline(ic);
        if (inlined != null) {
            this.name = inlined;
            changed = true;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.name.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CName && this.name.equals(((CName)obj).name) && super.equals(obj);
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.name, this.exprs});
    }

    @Override
    public final void plan(QueryString qs, String kind) {
        qs.token(kind);
        if (this.name instanceof QNm) {
            qs.token(((QNm)this.name).id());
        } else {
            qs.brace(this.name);
        }
        super.plan(qs, null);
    }
}

