/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class SwitchGroup
extends Arr {
    public SwitchGroup(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    @Override
    public void checkUp() throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            this.checkNoUp(this.exprs[e]);
        }
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
                continue;
            }
            catch (QueryException ex) {
                this.exprs[e] = cc.error(ex, this.exprs[e]);
            }
        }
        return this.optimize(cc);
    }

    @Override
    public SwitchGroup optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            this.exprs[e] = this.exprs[e].simplifyFor(CompileContext.Simplify.STRING, cc);
        }
        return (SwitchGroup)this.adoptType(this.rtrn());
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new SwitchGroup(this.info, SwitchGroup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return ic.inline(this.exprs, true) ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        Expr ex = this.rtrn();
        try {
            ex = tc.check(ex, cc);
        }
        catch (QueryException qe) {
            ex = cc.error(qe, ex);
        }
        if (ex == null) {
            return null;
        }
        this.exprs[0] = ex;
        return this.optimize(cc);
    }

    @Override
    public VarUsage count(Var var) {
        return this.rtrn().count(var);
    }

    VarUsage countCases(Var var) {
        VarUsage uses = VarUsage.NEVER;
        int el = this.exprs.length;
        for (int e = 1; e < el && (uses = uses.plus(this.exprs[e].count(var))) != VarUsage.MORE_THAN_ONCE; ++e) {
        }
        return uses;
    }

    boolean match(Item item, QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            Item cs = this.exprs[e].atomItem(qc, this.info);
            if (item != cs && (item == Empty.VALUE || cs == Empty.VALUE || !item.equiv(cs, null, this.info))) continue;
            return true;
        }
        return el == 1;
    }

    Expr rtrn() {
        return this.exprs[0];
    }

    boolean simplify(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this.rtrn().simplifyFor(mode, cc);
        if (expr == this.rtrn()) {
            return false;
        }
        this.exprs[0] = expr;
        return true;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        this.rtrn().markTailCalls(cc);
    }

    @Override
    public int exprSize() {
        int size = 0;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SwitchGroup && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            qs.token("case").token(this.exprs[e]);
        }
        if (el == 1) {
            qs.token("default");
        }
        qs.token("return").token(this.rtrn());
    }
}

