/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.Simple;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class ItrPos
extends Simple
implements CmpPos {
    final long min;
    final long max;

    private ItrPos(long min, long max, InputInfo info) {
        super(info, SeqType.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    public static Expr get(double pos, InputInfo ii) {
        long p = (long)pos;
        return (double)p != pos || p < 1L ? Bln.FALSE : ItrPos.get(p, p, ii);
    }

    public static Expr get(long min, long max, InputInfo ii) {
        return min > max || max < 1L ? Bln.FALSE : (min <= 1L && max == Long.MAX_VALUE ? Bln.TRUE : new ItrPos(Math.max(1L, min), Math.max(1L, max), ii));
    }

    static Expr get(Expr expr, CmpV.OpV op, InputInfo ii) throws QueryException {
        if (expr instanceof Value) {
            Value value = (Value)expr;
            if (value instanceof RangeSeq && op == CmpV.OpV.EQ) {
                long[] range = ((RangeSeq)value).range(false);
                return ItrPos.get(range[0], range[1], ii);
            }
            if (value.isItem()) {
                Item item = (Item)value;
                long pos = item.itr(ii);
                boolean exact = (double)pos == item.dbl(ii);
                switch (op) {
                    case EQ: {
                        return exact ? ItrPos.get(pos, pos, ii) : Bln.FALSE;
                    }
                    case GE: {
                        return ItrPos.get(exact ? pos : pos + 1L, Long.MAX_VALUE, ii);
                    }
                    case GT: {
                        return ItrPos.get(pos + 1L, Long.MAX_VALUE, ii);
                    }
                    case LE: {
                        return ItrPos.get(1L, pos, ii);
                    }
                    case LT: {
                        return ItrPos.get(1L, exact ? pos - 1L : pos, ii);
                    }
                    case NE: {
                        return exact ? (pos < 2L ? ItrPos.get(pos + 1L, Long.MAX_VALUE, ii) : null) : Bln.TRUE;
                    }
                }
            } else if (value.isEmpty()) {
                return Bln.FALSE;
            }
        }
        return null;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        return Bln.get(this.test(qc.focus.pos, qc) != 0);
    }

    @Override
    public boolean exact() {
        return this.min == this.max;
    }

    @Override
    public boolean simple() {
        return true;
    }

    @Override
    public int test(long pos, QueryContext qc) {
        return pos == this.max ? 2 : (pos >= this.min && pos <= this.max ? 1 : 0);
    }

    @Override
    public Expr inline(InlineContext ic) {
        return null;
    }

    @Override
    public ItrPos copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new ItrPos(this.min, this.max, this.info));
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exact()) {
            Expr pos = cc.function(Function.POSITION, this.info, new Expr[0]);
            return new CmpG(pos, (Expr)Int.get(this.min), CmpG.OpG.NE, null, cc.sc(), this.info).optimize(cc);
        }
        return this.min == 1L ? ItrPos.get(this.max + 1L, Long.MAX_VALUE, this.info) : (this.max == Long.MAX_VALUE ? ItrPos.get(1L, this.min - 1L, this.info) : this);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (!(ex instanceof ItrPos)) {
            return null;
        }
        ItrPos pos1 = this;
        ItrPos pos2 = (ItrPos)ex;
        if (pos2.min < pos1.min) {
            pos1 = pos2;
            pos2 = this;
        }
        return !or ? ItrPos.get(pos2.min, Math.min(pos1.max, pos2.max), this.info) : (pos1.max + 1L >= pos2.min ? ItrPos.get(pos1.min, Math.max(pos1.max, pos2.max), this.info) : null);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags) || Flag.CTX.in(flags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItrPos)) {
            return false;
        }
        ItrPos p = (ItrPos)obj;
        return this.min == p.min && this.max == p.max;
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max == Long.MAX_VALUE ? "inf" : Long.valueOf(this.max)), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]);
        if (this.exact()) {
            qs.token("=").token(this.min);
        } else if (this.max == Long.MAX_VALUE) {
            qs.token(">=").token(this.min);
        } else if (this.min == 1L) {
            qs.token("<=").token(this.max);
        } else {
            qs.token("=").token(this.min).token("to").token(this.max);
        }
    }
}

