/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class IterMap
extends SimpleMap {
    private final boolean[] items;

    IterMap(InputInfo info, Expr ... exprs) {
        super(info, exprs);
        int el = exprs.length;
        this.items = new boolean[el];
        for (int e = 0; e < el; ++e) {
            this.items[e] = exprs[e].seqType().zeroOrOne();
        }
    }

    @Override
    public Iter iter(final QueryContext qc) {
        final int el = this.exprs.length - 1;
        final Iter[] iters = new Iter[el + 1];
        final Value[] values = new Value[el + 1];
        values[0] = qc.focus.value;
        return new Iter(){
            int pos;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Item next() throws QueryException {
                QueryFocus qf = qc.focus;
                try {
                    do {
                        Item item;
                        qf.value = values[this.pos];
                        Iter iter = iters[this.pos];
                        if (IterMap.this.items[this.pos]) {
                            if (iter == Empty.ITER) {
                                iters[this.pos--] = null;
                                continue;
                            }
                            item = IterMap.this.exprs[this.pos].item(qc, IterMap.this.info);
                            if (item == Empty.VALUE) {
                                --this.pos;
                                continue;
                            }
                            iters[this.pos] = Empty.ITER;
                            if (this.pos >= el) {
                                Item item2 = item;
                                return item2;
                            }
                            values[++this.pos] = item;
                            continue;
                        }
                        if (iter == null) {
                            iters[this.pos] = iter = IterMap.this.exprs[this.pos].iter(qc);
                        }
                        if ((item = qc.next(iter)) == null) {
                            iters[this.pos--] = null;
                            continue;
                        }
                        if (this.pos >= el) {
                            Item item3 = item;
                            return item3;
                        }
                        values[++this.pos] = item;
                    } while (this.pos != -1);
                    Item item = null;
                    return item;
                }
                finally {
                    qf.value = values[0];
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        QueryFocus qf = qc.focus;
        Value qv = qf.value;
        try {
            Value value = this.exprs[0].value(qc);
            int el = this.exprs.length;
            for (int e = 1; e < el; ++e) {
                Item item;
                Expr expr = this.exprs[e];
                ValueBuilder vb = new ValueBuilder(qc);
                BasicIter<Item> iter = value.iter();
                while ((item = qc.next(iter)) != null) {
                    qf.value = item;
                    vb.add(expr.value(qc));
                }
                value = vb.value(expr);
            }
            Value value2 = value;
            return value2;
        }
        finally {
            qf.value = qv;
        }
    }

    @Override
    public IterMap copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new IterMap(this.info, Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public String description() {
        return "iterative " + super.description();
    }
}

