/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.CachedFilter;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Preds;
import org.basex.query.expr.Range;
import org.basex.query.expr.SimpleFilter;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Int;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class Filter
extends Preds {
    public Expr root;

    protected Filter(InputInfo info, Expr root, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
        this.root = root;
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr root, Expr ... preds) throws QueryException {
        return preds.length == 0 ? root : new CachedFilter(ii, root, preds).optimize(cc);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        super.checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        this.root = this.root.compile(cc);
        return super.compile(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        SeqType st;
        if (this.root instanceof Filter) {
            Filter filter = (Filter)this.root;
            this.root = filter.root;
            this.exprs = (Expr[])((ExprList)((ExprList)new ExprList().add(filter.exprs)).add(this.exprs)).finish();
        }
        if ((st = this.root.seqType()).zero()) {
            return cc.replaceWith(this, this.root);
        }
        if (this.simplify(cc, this.root)) {
            return cc.emptySeq(this);
        }
        if (this.exprs.length == 0) {
            return this.root;
        }
        if (!this.mayBePositional()) {
            if (this.root instanceof AxisPath) {
                return ((AxisPath)this.root).addPredicates(cc, this.exprs);
            }
            if (st.type == NodeType.DOCUMENT_NODE && this.root.ddo()) {
                Expr step = Step.get(cc, this.root, this.info, this.exprs);
                return cc.replaceWith(this, Path.get(cc, this.info, this.root, step));
            }
            Expr expr = this.exprs[0];
            if (this.exprs.length == 1 && expr.isSimple() && !expr.seqType().mayBeNumber()) {
                Expr iff = new If(this.info, expr, this.root).optimize(cc);
                return cc.replaceWith(this, iff);
            }
            return this.copyType(new IterFilter(this.info, this.root, this.exprs));
        }
        Expr expr = this.root;
        boolean opt = false;
        ExprList preds = new ExprList(this.exprs.length);
        QueryFunction<Expr, Expr> prepare = ex -> preds.isEmpty() ? ex : Filter.get(cc, this.info, ex, (Expr[])preds.next());
        for (Expr pred : this.exprs) {
            long es;
            Expr ex2 = null;
            if (Function.LAST.is(pred)) {
                ex2 = cc.function(Function._UTIL_LAST, this.info, prepare.apply(expr));
            } else if (pred instanceof ItrPos) {
                ItrPos pos = (ItrPos)pred;
                ex2 = pos.min != pos.max ? cc.function(Function._UTIL_RANGE, this.info, prepare.apply(expr), Int.get(pos.min), Int.get(pos.max)) : (pos.min == 1L ? cc.function(Function.HEAD, this.info, prepare.apply(expr)) : cc.function(Function._UTIL_ITEM, this.info, prepare.apply(expr), Int.get(pos.min)));
            } else if (pred instanceof Pos) {
                Pos pos = (Pos)pred;
                ex2 = pos.exact() ? cc.function(Function._UTIL_ITEM, this.info, prepare.apply(expr), pos.exprs[0]) : cc.function(Function._UTIL_RANGE, this.info, prepare.apply(expr), pos.exprs[0], pos.exprs[1]);
            } else if (Filter.numeric(pred)) {
                if (pred.seqType().one()) {
                    ex2 = cc.function(Function._UTIL_ITEM, this.info, prepare.apply(expr), pred);
                }
            } else if (pred instanceof Cmp) {
                Cmp cmp = (Cmp)pred;
                CmpV.OpV opV = cmp.opV();
                if (cmp.positional() && opV != null) {
                    Expr e = cmp.exprs[1];
                    if ((opV == CmpV.OpV.LT || opV == CmpV.OpV.NE) && Function.LAST.is(e)) {
                        ex2 = cc.function(Function._UTIL_INIT, this.info, prepare.apply(expr));
                    } else if (opV == CmpV.OpV.NE && e.seqType().instanceOf(SeqType.INTEGER_O) && e.isSimple()) {
                        ex2 = cc.function(Function.REMOVE, this.info, prepare.apply(expr), e);
                    } else if (opV == CmpV.OpV.EQ && e instanceof Range) {
                        Expr arg1 = e.arg(0);
                        Expr arg2 = e.arg(1);
                        if (Function.LAST.is(arg2) && arg1.seqType().instanceOf(SeqType.INTEGER_O) && arg1.isSimple()) {
                            ex2 = cc.function(Function.SUBSEQUENCE, this.info, prepare.apply(expr), arg1);
                        } else if (arg1 == Int.ONE && arg2 instanceof Arith) {
                            Expr arth1 = arg2.arg(0);
                            Expr arth2 = arg2.arg(1);
                            if (Function.LAST.is(arth1) && ((Arith)arg2).calc == Calc.MINUS && arth2 == Int.ONE) {
                                ex2 = cc.function(Function._UTIL_INIT, this.info, prepare.apply(expr));
                            }
                        }
                    }
                }
            } else if (pred instanceof Arith && Function.LAST.is(pred.arg(0)) && preds.isEmpty() && (es = expr.size()) != -1L) {
                ex2 = cc.function(Function._UTIL_ITEM, this.info, prepare.apply(expr), new Arith(this.info, Int.get(es), pred.arg(1), ((Arith)pred).calc).optimize(cc));
            }
            if (ex2 != null) {
                expr = ex2;
                opt = true;
                continue;
            }
            preds.add(pred);
        }
        if (opt) {
            return cc.replaceWith(this, prepare.apply(expr));
        }
        return this.copyType(this.exprs.length == 1 && this.exprs[0].isSimple() ? new SimpleFilter(this.info, this.root, this.exprs) : new CachedFilter(this.info, this.root, this.exprs));
    }

    @Override
    protected final void type(Expr expr) {
        this.exprType.assign(this.root.seqType().union(Occ.ZERO));
    }

    public final Expr addPredicate(CompileContext cc, Expr pred) throws QueryException {
        this.exprs = (Expr[])((ExprList)((Object)((ExprList)new ExprList(this.exprs.length + 1).add(this.exprs)).add(pred))).finish();
        return this.copyType(Filter.get(cc, this.info, this.root, this.exprs));
    }

    public final Expr simplifyCount(CompileContext cc) throws QueryException {
        if (this.exprs.length != 1) {
            return this;
        }
        Expr pred = this.exprs[0];
        if (pred.seqType().instanceOf(SeqType.NODE_ZO)) {
            return SimpleMap.get(cc, this.info, this.root, pred);
        }
        java.util.function.Function<Expr, Integer> type = expr -> {
            Type t = expr.seqType().type;
            return t.isStringOrUntyped() ? 1 : (t.isNumber() ? 2 : 0);
        };
        int rtype = type.apply(this.root);
        if (rtype != 0 && pred instanceof CmpG && ((CmpG)pred).opV() == CmpV.OpV.EQ) {
            Expr op2 = pred.arg(1);
            if (pred.arg(0) instanceof ContextValue && op2.seqType().one() && type.apply(op2) == rtype) {
                return cc.function(Function.INDEX_OF, this.info, this.root, op2);
            }
        }
        return this;
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr;
        if (mode == CompileContext.Simplify.EBV || mode == CompileContext.Simplify.PREDICATE) {
            Expr expr2 = this.flattenEbv(this.root, true, cc);
            if (expr2 != this) {
                return cc.simplify(this, expr2);
            }
        } else if (mode == CompileContext.Simplify.DISTINCT && !this.mayBePositional() && (expr = this.root.simplifyFor(mode, cc)) != this.root) {
            return Filter.get(cc, this.info, expr, this.exprs);
        }
        return super.simplifyFor(mode, cc);
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (this.root.has(flags)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        return this.root.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage inRoot = this.root.count(var);
        if (var == null) {
            return inRoot;
        }
        VarUsage inPreds = super.count(var);
        return inPreds == VarUsage.NEVER ? inRoot : (this.root.seqType().zeroOrOne() ? inRoot.plus(inPreds) : VarUsage.MORE_THAN_ONCE);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        boolean changed;
        Expr inlined = this.root.inline(ic);
        boolean bl = changed = inlined != null;
        if (changed) {
            this.root = inlined;
        }
        return (changed |= ic.var != null && ic.cc.ok(this.root, () -> ic.inline(this.exprs))) ? this.optimize(ic.cc) : null;
    }

    @Override
    public final Data data() {
        return this.root.data();
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        for (Expr expr : this.exprs) {
            visitor.enterFocus();
            if (!expr.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return this.root.accept(visitor);
    }

    @Override
    public boolean ddo() {
        return this.root.ddo();
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.root.exprSize();
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof Filter && this.root.equals(((Filter)obj).root) && super.equals(obj);
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.root, this.exprs});
    }

    @Override
    public final void plan(QueryString qs) {
        qs.token(this.root);
        super.plan(qs);
    }
}

