/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.BitSet;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.TypeCheck;
import org.basex.query.iter.AtomIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Expr
extends ExprInfo {
    public abstract void checkUp() throws QueryException;

    public abstract Expr compile(CompileContext var1) throws QueryException;

    public Expr optimize(CompileContext cc) throws QueryException {
        return this;
    }

    public abstract Iter iter(QueryContext var1) throws QueryException;

    public abstract Value value(QueryContext var1) throws QueryException;

    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    public Iter atomIter(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter = this.iter(qc);
        SeqType st = this.seqType();
        if (st.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            return iter;
        }
        long size = iter.size();
        if (size != -1L && st.mayBeArray()) {
            size = -1L;
        }
        return new AtomIter(iter, qc, ii, size);
    }

    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.atomValue(qc, ii).item(qc, ii);
    }

    public abstract Value atomValue(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Item ebv(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Item test(QueryContext var1, InputInfo var2) throws QueryException;

    public boolean vacuous() {
        return false;
    }

    public Data data() {
        return null;
    }

    public void data(Data dt) {
    }

    public abstract long size();

    public abstract boolean has(Flag ... var1);

    public final boolean uses(final Var var) {
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                return !ref.var.is(var);
            }
        });
    }

    public abstract boolean inlineable(InlineContext var1);

    public abstract VarUsage count(Var var1);

    public abstract Expr inline(InlineContext var1) throws QueryException;

    public abstract Expr copy(CompileContext var1, IntObjMap<Var> var2);

    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return (mode == CompileContext.Simplify.EBV || mode == CompileContext.Simplify.PREDICATE) && this.seqType().instanceOf(SeqType.NODE_OM) && !this.has(Flag.NDT) ? cc.simplify(this, Bln.TRUE) : this;
    }

    public abstract SeqType seqType();

    public FuncType funcType() {
        Type type = this.seqType().type;
        return type instanceof FuncType ? (FuncType)type : null;
    }

    public boolean ddo() {
        SeqType st = this.seqType();
        return st.zeroOrOne() && st.type instanceof NodeType;
    }

    public Expr[] args() {
        return null;
    }

    public final Expr arg(int i) {
        return this.args()[i];
    }

    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        return false;
    }

    public final boolean isSimple() {
        return !this.has(Flag.CTX, Flag.NDT, Flag.HOF, Flag.POS);
    }

    protected boolean hasFreeVars() {
        final BitSet declared = new BitSet();
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean declared(Var var) {
                declared.set(var.id);
                return true;
            }

            @Override
            public boolean used(VarRef ref) {
                return declared.get(ref.var.id);
            }
        });
    }

    public Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        return null;
    }

    public void markTailCalls(CompileContext cc) {
    }

    public abstract boolean accept(ASTVisitor var1);

    protected static boolean visitAll(ASTVisitor visitor, Expr ... exprs) {
        for (Expr expr : exprs) {
            if (expr.accept(visitor)) continue;
            return false;
        }
        return true;
    }

    public abstract int exprSize();

    public abstract void refineType(Expr var1);

    protected Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        return null;
    }

    public abstract boolean equals(Object var1);
}

