/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.path.NameTest;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Catch
extends Single {
    public static final QNm[] NAMES = new QNm[]{Catch.create(QueryText.E_CODE), Catch.create(QueryText.E_DESCRIPTION), Catch.create(QueryText.E_VALUE), Catch.create(QueryText.E_MODULE), Catch.create(QueryText.E_LINE_NUMBER), Catch.create(QueryText.E_COLUMN_NUMBER), Catch.create(QueryText.E_ADDITIONAL)};
    public static final SeqType[] TYPES = new SeqType[]{SeqType.QNAME_O, SeqType.STRING_ZO, SeqType.ITEM_ZM, SeqType.STRING_ZO, SeqType.INTEGER_ZO, SeqType.INTEGER_ZO, SeqType.ITEM_ZM};
    private final ArrayList<NameTest> tests;
    private final Var[] vars;

    public Catch(InputInfo info, NameTest[] tests, Var[] vars) {
        super(info, null, SeqType.ITEM_ZM);
        this.tests = new ArrayList<NameTest>(Arrays.asList(tests));
        this.vars = vars;
    }

    @Override
    public Catch compile(CompileContext cc) {
        try {
            this.expr = this.expr.compile(cc);
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        return this.optimize(cc);
    }

    @Override
    public Catch optimize(CompileContext cc) {
        return (Catch)this.adoptType(this.expr);
    }

    Value value(QueryContext qc, QueryException qe) throws QueryException {
        Util.debug(qe);
        int i = 0;
        for (Value value : Catch.values(qe)) {
            qc.set(this.vars[i++], value);
        }
        return this.expr.value(qc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Var[] vrs = new Var[NAMES.length];
        int vl = vrs.length;
        for (int v = 0; v < vl; ++v) {
            vrs[v] = cc.vs().addNew(NAMES[v], TYPES[v], false, cc.qc, this.info);
        }
        Catch ctch = new Catch(this.info, this.tests.toArray(new NameTest[0]), vrs);
        int val = this.vars.length;
        for (int v = 0; v < val; ++v) {
            vm.put(this.vars[v].id, ctch.vars[v]);
        }
        ctch.expr = this.expr.copy(cc, vm);
        return this.copyType(ctch);
    }

    @Override
    public Catch inline(InlineContext ic) {
        try {
            Expr inlined = this.expr.inline(ic);
            if (inlined == null) {
                return null;
            }
            this.expr = inlined;
        }
        catch (QueryException qe) {
            this.expr = ic.cc.error(qe, this.expr);
        }
        return this;
    }

    Expr inline(QueryException qe, CompileContext cc) throws QueryException {
        if (this.expr instanceof Value) {
            return this.expr;
        }
        Expr ex = this.expr;
        int v = 0;
        for (Value value : Catch.values(qe)) {
            ex = new InlineContext(this.vars[v++], value, cc).inline(ex);
        }
        return ex;
    }

    public static Value[] values(QueryException qe) {
        byte[] io = qe.file() == null ? Token.EMPTY : Token.token(qe.file());
        Value value = qe.value();
        return new Value[]{qe.qname(), Str.get(qe.getLocalizedMessage()), value == null ? Empty.VALUE : value, Str.get(io), Int.get(qe.line()), Int.get(qe.column()), Str.get(qe.getMessage().replaceAll("\r\n?", "\n"))};
    }

    boolean simplify(ArrayList<NameTest> list, CompileContext cc) {
        if (list.contains(null)) {
            cc.info("simplify %: %", this::description, "*");
            return false;
        }
        for (NameTest test : this.tests) {
            if (test != null) continue;
            list.add(null);
            cc.info("simplify %: %", this::description, "*");
            this.tests.clear();
            this.tests.add(null);
            return true;
        }
        Iterator<NameTest> iter = this.tests.iterator();
        while (iter.hasNext()) {
            NameTest test;
            test = iter.next();
            if (list.contains(test)) {
                cc.info("remove % from %", test != null ? test : "*", this::description);
                iter.remove();
                continue;
            }
            list.add(test);
        }
        return !this.tests.isEmpty();
    }

    boolean matches(QueryException qe) {
        QNm name = qe.qname();
        for (NameTest test : this.tests) {
            if (test != null && !test.matches(name)) continue;
            return true;
        }
        return false;
    }

    private static QNm create(byte[] name) {
        return new QNm(Token.concat(QueryText.ERR_PREFIX, Token.COLON, name), QueryText.ERROR_URI);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Var var : this.vars) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return Catch.visitAll(visitor, this.expr);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Catch)) {
            return false;
        }
        Catch ctch = (Catch)obj;
        return Array.equals(this.vars, ctch.vars) && this.tests.equals(ctch.tests) && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("catch");
        int c = 0;
        for (NameTest test : this.tests) {
            if (c++ > 0) {
                qs.token('|');
            }
            qs.token(test != null ? test.toString(false) : "*");
        }
        qs.brace(this.expr);
    }
}

