/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Castable
extends Single {
    private final StaticContext sc;
    private final SeqType seqType;

    public Castable(StaticContext sc, InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.sc = sc;
        this.seqType = seqType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        SeqType est = this.expr.seqType();
        Type dt = this.seqType.type;
        Occ o = this.seqType.occ;
        if (dt instanceof ListType) {
            dt = dt.atomic();
            o = Occ.ZERO_OR_MORE;
        } else if (o == Occ.ZERO_OR_ONE && est.oneOrMore() && !est.mayBeArray()) {
            o = Occ.EXACTLY_ONE;
        }
        if (!est.mayBeArray()) {
            long es = this.expr.size();
            if (es != -1L && (es < o.min || es > o.max)) {
                return cc.replaceWith(this, Bln.FALSE);
            }
            Type et = est.type;
            if (et.instanceOf(dt) && est.occ.instanceOf(o) && (et.eq(dt) || dt == AtomType.NUMERIC)) {
                return cc.replaceWith(this, Bln.TRUE);
            }
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.seqType.cast(this.expr.atomValue(qc, this.info), false, qc, this.sc, this.info) != null);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Castable(this.sc, this.info, this.expr.copy(cc, vm), this.seqType));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Castable && this.seqType.eq(((Castable)obj).seqType) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "as", this.seqType), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.expr).token("castable").token("as").token(this.seqType);
    }
}

