/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.Value;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Cast
extends Single {
    private final StaticContext sc;
    final SeqType seqType;

    public Cast(StaticContext sc, InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, SeqType.ITEM_ZM);
        this.sc = sc;
        this.seqType = seqType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        SeqType est = this.expr.seqType();
        Type dt = this.seqType.type;
        Occ o = this.seqType.occ;
        if (dt instanceof ListType) {
            dt = dt.atomic();
            o = Occ.ZERO_OR_MORE;
        } else if (o == Occ.ZERO_OR_ONE && est.oneOrMore() && !est.mayBeArray()) {
            o = Occ.EXACTLY_ONE;
        }
        this.exprType.assign(dt, o);
        if (!est.mayBeArray()) {
            long es = this.expr.size();
            if (es != -1L && (es < o.min || es > o.max)) {
                throw this.error(this.expr);
            }
            Type et = est.type;
            if (et.instanceOf(dt) && est.occ.instanceOf(o) && (et.eq(dt) || dt == AtomType.NUMERIC)) {
                return cc.replaceWith(this, this.expr);
            }
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.seqType.cast(this.expr.atomValue(qc, this.info), true, qc, this.sc, this.info);
    }

    private QueryException error(Expr ex) {
        return QueryError.INVTYPE_X_X_X.get(this.info, ex.seqType(), this.seqType, ex);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return this.simplifyForCast(mode, cc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Cast(this.sc, this.info, this.expr.copy(cc, vm), this.seqType));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Cast && this.seqType.eq(((Cast)obj).seqType) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "as", this.seqType), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.seqType.one()) {
            qs.token("(").token(this.expr).token("cast").token("as").token(this.seqType).token(')');
        } else {
            qs.token(this.seqType.type).paren(this.expr);
        }
    }
}

