/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.Unary;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Arith
extends Arr {
    public final Calc calc;

    public Arith(InputInfo info, Expr expr1, Expr expr2, Calc calc) {
        super(info, SeqType.ANY_ATOMIC_TYPE_ZO, expr1, expr2);
        this.calc = calc;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        if (this.allAreValues(false)) {
            return cc.preEval(this);
        }
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if ((this.calc == Calc.PLUS || this.calc == Calc.MULT) && expr1 instanceof Value && !(expr2 instanceof Value)) {
            cc.info("swap operands: %", this);
            this.exprs[0] = expr2;
            this.exprs[1] = expr1;
            expr1 = this.exprs[0];
            expr2 = this.exprs[1];
        }
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Type type1 = st1.type;
        Type type2 = st2.type;
        boolean nums = type1.isNumberOrUntyped() && type2.isNumberOrUntyped();
        Type type = this.calc.type(type1, type2);
        boolean noarray = !st1.mayBeArray() && !st2.mayBeArray();
        boolean one = noarray && st1.oneOrMore() && st2.oneOrMore();
        this.exprType.assign(type, one ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE);
        Expr expr = this.emptyExpr();
        if (expr == this && expr1 == Int.ZERO && this.calc == Calc.MINUS) {
            expr = new Unary(this.info, expr2, true).optimize(cc);
        }
        if (expr == this && Function.COUNT.is(expr1) && this.calc == Calc.PLUS && Function.COUNT.is(expr2)) {
            expr = cc.function(Function.COUNT, this.info, List.get(cc, this.info, expr1.arg(0), expr2.arg(0)));
        }
        if (expr == this && nums && noarray && st1.one() && st2.one()) {
            Expr ex = this.calc.optimize(expr1, expr2, this.info, cc);
            if (ex != null) {
                expr = ex;
            } else if (expr1 instanceof Arith) {
                Calc acalc = ((Arith)expr1).calc;
                Expr arg1 = expr1.arg(0);
                Expr arg2 = expr1.arg(1);
                if (arg2 instanceof Value && expr2 instanceof Value && (acalc == this.calc || acalc == this.calc.invert())) {
                    Calc ncalc;
                    Calc calc = acalc == Calc.PLUS || acalc == Calc.MULT ? this.calc : (ncalc = acalc == Calc.MINUS || acalc == Calc.DIV ? this.calc.invert() : null);
                    if (ncalc != null) {
                        expr = new Arith(this.info, arg1, new Arith(this.info, arg2, expr2, ncalc).optimize(cc), acalc).optimize(cc);
                    }
                } else if (acalc == this.calc.invert() && arg2.equals(expr2)) {
                    expr = arg1.seqType().instanceOf(SeqType.NUMERIC_O) ? arg1 : new Cast(cc.sc(), this.info, arg1, SeqType.NUMERIC_O).optimize(cc);
                }
            }
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        return item2 == Empty.VALUE ? Empty.VALUE : this.calc.eval(item1, item2, this.info);
    }

    @Override
    public Arith copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Arith(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.calc));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Arith && this.calc == ((Arith)obj).calc && super.equals(obj);
    }

    @Override
    public String description() {
        return '\'' + this.calc.name + "' expression";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.calc.name), this.exprs);
    }

    @Override
    public void plan(QueryString qs) {
        qs.tokens(this.exprs, ' ' + this.calc.name + ' ', true);
    }
}

