/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayDeque;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QuerySupplier;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.path.Step;
import org.basex.query.func.AFunction;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.Scope;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CompileContext {
    public static final int MAX_PREEVAL = 262144;
    public final QueryContext qc;
    private final ArrayDeque<VarScope> scopes = new ArrayDeque();
    private final ArrayDeque<QueryFocus> focuses = new ArrayDeque();

    public CompileContext(QueryContext qc) {
        this.qc = qc;
    }

    public void info(String string, Object ... ext) {
        if (this.qc.parent == null) {
            this.qc.info.compInfo(string, ext);
        }
    }

    public void pushScope(VarScope vs) {
        this.scopes.add(vs);
    }

    public VarScope removeScope() {
        return this.scopes.removeLast();
    }

    public void removeScope(Scope scope) {
        this.removeScope().cleanUp(scope);
    }

    public void pushFocus(Expr expr) {
        this.focuses.add(this.qc.focus);
        QueryFocus qf = new QueryFocus();
        if (expr != null) {
            qf.value = this.dummyItem(expr);
        }
        this.qc.focus = qf;
    }

    public void updateFocus(Expr expr) {
        this.qc.focus.value = this.dummyItem(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr get(Expr expr, QuerySupplier<Expr> func) throws QueryException {
        this.pushFocus(expr);
        try {
            Expr expr2 = func.get();
            return expr2;
        }
        finally {
            this.removeFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ok(Expr expr, QuerySupplier<Boolean> func) throws QueryException {
        this.pushFocus(expr);
        try {
            boolean bl = func.get();
            return bl;
        }
        finally {
            this.removeFocus();
        }
    }

    private Item dummyItem(Expr expr) {
        Value value;
        Data data = expr.data();
        if (data == null && expr instanceof Step && (value = this.qc.focus.value) != null) {
            data = value.data();
        }
        return new Dummy(expr.seqType().with(Occ.EXACTLY_ONE), data);
    }

    public void removeFocus() {
        this.qc.focus = this.focuses.pollLast();
    }

    public boolean nestedFocus() {
        return !this.focuses.isEmpty();
    }

    public VarScope vs() {
        return this.scopes.getLast();
    }

    public StaticContext sc() {
        return this.vs().sc;
    }

    public Var copy(Var var, IntObjMap<Var> vm) {
        if (var == null) {
            return null;
        }
        VarScope vs = this.vs();
        Var vr = vs.add(new Var(var, this.qc, vs.sc));
        if (vm != null) {
            vm.put(var.id, vr);
        }
        return vr;
    }

    public Expr preEval(Expr expr) throws QueryException {
        return this.replaceWith(expr, expr.value(this.qc));
    }

    public Expr emptySeq(Expr expr) {
        return this.replaceWith(expr, Empty.VALUE, false);
    }

    public Expr simplify(Expr expr, Expr result) {
        return this.replaceWith(expr, result, false);
    }

    public Expr replaceWith(Expr expr, Expr result) {
        return this.replaceWith(expr, result, true);
    }

    private Expr replaceWith(Expr expr, Expr result, boolean refine) {
        Expr res;
        Expr expr2 = res = result.seqType().zero() && !result.has(Flag.NDT) ? Empty.VALUE : result;
        if (res != expr) {
            this.info("%", () -> {
                TokenBuilder tb = new TokenBuilder();
                String exprDesc = expr.description();
                String resDesc = res.description();
                tb.add("rewrite").add(32).add(exprDesc);
                if (!exprDesc.equals(resDesc)) {
                    tb.add(" to ").add(resDesc);
                }
                byte[] exprString = QueryError.normalize(Token.token(expr.toString()), null);
                byte[] resString = QueryError.normalize(Token.token(res.toString()), null);
                tb.add(": ").add(exprString);
                if (!Token.eq(exprString, resString)) {
                    tb.add(" -> ").add(resString);
                }
                return tb.toString();
            });
            if (refine) {
                res.refineType(expr);
            }
        }
        return res;
    }

    public StandardFunc error(QueryException qe, Expr expr) {
        return FnError.get(qe, expr.seqType(), this.sc());
    }

    public Expr function(AFunction function, InputInfo ii, Expr ... exprs) throws QueryException {
        return function.get(this.sc(), ii, exprs).optimize(this);
    }

    public Expr merge(Expr cond, Expr rtrn, InputInfo ii) throws QueryException {
        return cond.has(Flag.NDT) ? List.get(this, ii, this.function(Function._PROF_VOID, ii, cond), rtrn) : rtrn;
    }

    public Expr replicate(Expr expr, Expr count, InputInfo ii) throws QueryException {
        ExprList args = (ExprList)((Object)((ExprList)((Object)new ExprList().add(expr))).add(count));
        if (expr.has(Flag.NDT, Flag.CNS)) {
            args.add(Bln.TRUE);
        }
        return this.function(Function._UTIL_REPLICATE, ii, (Expr[])args.finish());
    }

    public static enum Simplify {
        EBV,
        DATA,
        STRING,
        NUMBER,
        PREDICATE,
        DISTINCT;

    }
}

