/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.build.json.JsonSerialOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.StandardSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.options.Options;

public abstract class JsonSerializer
extends StandardSerializer {
    final JsonSerialOptions jopts;
    private final boolean escape;
    private final boolean nodups;

    JsonSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
        this.jopts = opts.get(SerializerOptions.JSON);
        this.escape = this.jopts.get(JsonSerialOptions.ESCAPE);
        this.nodups = opts.get(SerializerOptions.ALLOW_DUPLICATE_NAMES) == Options.YesNo.NO;
        Boolean ji = this.jopts.get(JsonSerialOptions.INDENT);
        if (ji != null) {
            this.indent = ji;
        }
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep) {
            throw QueryError.SERJSON.getIO(new Object[0]);
        }
        if (item == null) {
            this.out.print(JsonConstants.NULL);
        } else {
            super.serialize(item);
        }
        this.sep = true;
    }

    private void serialize(Value value) throws IOException {
        if (value.size() > 1L) {
            throw QueryError.SERJSONSEQ.getIO(new Object[0]);
        }
        this.sep = false;
        this.serialize(value.isEmpty() ? null : (Item)value);
    }

    @Override
    public void function(FItem item) throws IOException {
        block11: {
            try {
                if (item instanceof XQMap) {
                    ++this.level;
                    this.out.print(123);
                    boolean s = false;
                    TokenSet set = this.nodups ? new TokenSet() : null;
                    XQMap m = (XQMap)item;
                    for (Item key : m.keys()) {
                        byte[] name = key.string(null);
                        if (this.nodups) {
                            if (set.contains(name)) {
                                throw QueryError.SERDUPL_X.getIO(new Object[]{name});
                            }
                            set.put(name);
                        }
                        if (s) {
                            this.out.print(44);
                        }
                        this.indent();
                        this.string(name);
                        this.out.print(58);
                        if (this.indent) {
                            this.out.print(32);
                        }
                        this.serialize(m.get(key, null));
                        s = true;
                    }
                    --this.level;
                    this.indent();
                    this.out.print(125);
                    break block11;
                }
                if (item instanceof XQArray) {
                    ++this.level;
                    this.out.print(91);
                    boolean s = false;
                    for (Value value : ((XQArray)item).members()) {
                        if (s) {
                            this.out.print(44);
                        }
                        this.indent();
                        this.serialize(value);
                        s = true;
                    }
                    --this.level;
                    this.indent();
                    this.out.print(93);
                    break block11;
                }
                throw QueryError.SERJSONFUNC_X.getIO(item.type);
            }
            catch (QueryException ex) {
                throw new QueryIOException(ex);
            }
        }
        this.sep = true;
    }

    @Override
    protected void atomic(Item item) throws IOException {
        try {
            if (item.type.isNumber()) {
                byte[] str = item.string(null);
                if (Token.eq(str, Token.NAN, Token.INF, Token.NEGATVE_INF)) {
                    throw QueryError.SERNUMBER_X.getIO(new Object[]{str});
                }
                this.out.print(str);
            } else if (item.type == AtomType.BOOLEAN) {
                this.out.print(item.string(null));
            } else {
                this.string(item.string(null));
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    protected final void string(byte[] string) throws IOException {
        this.out.print(34);
        byte[] str = this.norm(string);
        int sl = str.length;
        for (int s = 0; s < sl; s += Token.cl(str, s)) {
            this.printChar(Token.cp(str, s));
        }
        this.out.print(34);
    }

    @Override
    protected final void print(int cp) throws IOException {
        if (this.escape) {
            switch (cp) {
                case 8: {
                    this.out.print("\\b");
                    break;
                }
                case 12: {
                    this.out.print("\\f");
                    break;
                }
                case 10: {
                    this.out.print("\\n");
                    break;
                }
                case 13: {
                    this.out.print("\\r");
                    break;
                }
                case 9: {
                    this.out.print("\\t");
                    break;
                }
                case 34: {
                    this.out.print("\\\"");
                    break;
                }
                case 47: {
                    this.out.print("\\/");
                    break;
                }
                case 92: {
                    this.out.print("\\\\");
                    break;
                }
                default: {
                    this.out.print(cp);
                    break;
                }
            }
        } else {
            super.print(cp);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.sep) {
            this.out.print(JsonConstants.NULL);
        }
        super.close();
    }
}

