/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.util.XMLToken;

final class CsvDirectConverter
extends CsvConverter {
    private FDoc doc;
    private FElem root;
    private FElem record;

    CsvDirectConverter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    protected void record() {
        this.record = new FElem(RECORD);
        this.root.add(this.record);
        this.col = 0;
    }

    @Override
    protected void header(byte[] value) {
        this.headers.add(this.ats ? value : XMLToken.encode(value, this.lax));
    }

    @Override
    protected void entry(byte[] entry) {
        FElem e;
        byte[] name = (byte[])this.headers.get(this.col++);
        if (this.ats) {
            e = new FElem(ENTRY);
            if (name != null) {
                e.add(NAME, name);
            }
        } else {
            e = new FElem(name == null ? ENTRY : name);
        }
        this.record.add(e.add(entry));
    }

    @Override
    protected void init(String uri) {
        this.doc = new FDoc(uri);
        this.root = new FElem(CSV);
    }

    @Override
    protected FDoc finish() {
        return this.doc.add(this.root);
    }
}

