/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.MetaData;
import org.basex.io.out.DataOutput;

public final class TableOutput
extends OutputStream {
    private final byte[] buffer = new byte[4096];
    private final OutputStream os;
    private final MetaData meta;
    private final String file;
    private int pos;
    private int pages;

    public TableOutput(MetaData md, String fn) throws IOException {
        this.os = md.dbFile(fn).outputStream();
        this.meta = md;
        this.file = fn;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == 4096) {
            this.writeBuffer();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    private void writeBuffer() throws IOException {
        this.os.write(this.buffer);
        ++this.pages;
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        boolean empty;
        boolean bl = empty = this.pages == 0 && this.pos == 0;
        if (this.pos > 0 || empty) {
            this.writeBuffer();
        }
        this.os.close();
        try (DataOutput out = new DataOutput(this.meta.dbFile(this.file + 'i'));){
            out.writeNum(this.pages);
            out.writeNum(empty ? 0 : Integer.MAX_VALUE);
        }
    }
}

