/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOFile
extends IO {
    public static final FileFilter NO_HIDDEN = file -> !Strings.startsWith(file.getName(), '.');
    private static final Pattern VALIDNAME = Pattern.compile("^[^\\\\/" + (Prop.WIN ? ":*?\"<>|" : "") + "]+$");
    private final boolean absolute;
    private final File file;

    public IOFile(File file) {
        this(file, "");
    }

    public IOFile(String path) {
        this(new File(path), path);
    }

    public IOFile(String dir, String child) {
        this(new File(dir, child), child);
    }

    public IOFile(IOFile dir, String child) {
        this(new File(dir.file, child), child);
    }

    private IOFile(File file, String last) {
        super(IOFile.create(file.getAbsolutePath(), Strings.endsWith(last, '/') || Strings.endsWith(last, '\\')));
        boolean abs = file.isAbsolute();
        File file2 = this.file = abs ? file : new File(this.pth);
        if (!abs && Prop.WIN) {
            String p = file.getPath();
            abs = Strings.startsWith(p, '/') || Strings.startsWith(p, '\\');
        }
        this.absolute = abs;
    }

    public File file() {
        return this.file;
    }

    public boolean touch() {
        try {
            Files.createFile(this.toPath(), new FileAttribute[0]);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    public byte[] read() throws IOException {
        return Files.readAllBytes(this.toPath());
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public long timeStamp() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.url());
    }

    @Override
    public StreamSource streamSource() {
        return new StreamSource(this.pth);
    }

    @Override
    public FileInputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public FileOutputStream outputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public IOFile resolve(String path) {
        IOFile f = new IOFile(path);
        return f.absolute ? f : new IOFile(this.isDir() ? this.pth : this.dir(), path);
    }

    public boolean md() {
        return this.file.exists() || this.file.mkdirs();
    }

    public IOFile parent() {
        String parent = this.file.getParent();
        return parent == null ? null : new IOFile(parent + '/');
    }

    public IOFile[] children() {
        return this.children((FileFilter)null);
    }

    public IOFile[] children(String regex) {
        File[] children = this.file.listFiles();
        if (children == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>();
        Pattern pattern = Pattern.compile(regex, Prop.CASE ? 0 : 2);
        for (File child : children) {
            if (!pattern.matcher(child.getName()).matches()) continue;
            io.add(child.isDirectory() ? new IOFile(child.getPath() + '/') : new IOFile(child));
        }
        return io.toArray(new IOFile[0]);
    }

    public IOFile[] children(FileFilter filter) {
        File[] children;
        File[] fileArray = children = filter == null ? this.file.listFiles() : this.file.listFiles(filter);
        if (children == null) {
            return new IOFile[0];
        }
        ArrayList<IOFile> io = new ArrayList<IOFile>(children.length);
        for (File child : children) {
            io.add(child.isDirectory() ? new IOFile(child + "/") : new IOFile(child));
        }
        return io.toArray(new IOFile[0]);
    }

    public StringList descendants() {
        return this.descendants(null);
    }

    public StringList descendants(FileFilter filter) {
        StringList files = new StringList();
        if (this.isDir()) {
            int offset = this.path().length() + (Strings.endsWith(this.path(), '/') ? 0 : 1);
            IOFile.addDescendants(this, files, filter, offset);
        }
        return files;
    }

    public void write(String string) throws IOException {
        this.write(Token.token(string));
    }

    public void write(byte[] bytes) throws IOException {
        Files.write(this.toPath(), bytes, new OpenOption[0]);
    }

    public void write(InputStream is) throws IOException {
        try (BufferInput in = BufferInput.get(is);
             BufferOutput out = new BufferOutput(this);){
            int i;
            while ((i = in.read()) != -1) {
                out.write(i);
            }
        }
    }

    public boolean delete() {
        boolean ok = true;
        if (this.file.exists()) {
            if (this.isDir()) {
                for (IOFile ch : this.children()) {
                    ok &= ch.delete();
                }
            }
            try {
                Files.delete(this.toPath());
            }
            catch (IOException ex) {
                Util.debug(ex);
                return false;
            }
        }
        return ok;
    }

    public boolean rename(IOFile target) {
        return this.file.renameTo(target.file);
    }

    public void copyTo(IOFile target) throws IOException {
        target.parent().md();
        Files.copy(this.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public boolean eq(IO io) {
        return io instanceof IOFile && (Prop.CASE ? this.pth.equals(io.pth) : this.pth.equalsIgnoreCase(io.pth));
    }

    public boolean equals(Object obj) {
        return obj instanceof IOFile && this.pth.equals(((IOFile)obj).pth);
    }

    @Override
    public String url() {
        String path = Strings.startsWith(this.pth, '/') ? this.pth.substring(1) : this.pth;
        TokenBuilder tb = new TokenBuilder().add("file:/").add("//");
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            char ch = path.charAt(p);
            if (ch == ' ') {
                tb.add("%20");
                continue;
            }
            tb.add(ch);
        }
        return tb.toString();
    }

    public void open() throws IOException {
        String[] args = Prop.WIN ? new String[]{"rundll32", "url.dll,FileProtocolHandler", this.pth} : (Prop.MAC ? new String[]{"/usr/bin/open", this.pth} : new String[]{"xdg-open", this.pth});
        new ProcessBuilder(args).directory(this.parent().file).start();
    }

    public IOFile normalize() {
        try {
            Path path = this.toPath().toRealPath(new LinkOption[0]);
            return new IOFile(path + (Files.isDirectory(path, new LinkOption[0]) ? "/" : ""));
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this;
        }
    }

    public boolean isHidden() {
        return this.file.isHidden() || Strings.startsWith(this.name(), '.') || this.name().equals("node_modules");
    }

    public boolean ignore() {
        return this.name().equals(".ignore");
    }

    private Path toPath() throws IOException {
        try {
            return Paths.get(this.pth, new String[0]);
        }
        catch (InvalidPathException ex) {
            Util.debug(ex);
            throw new IOException(ex);
        }
    }

    private static void addDescendants(IOFile io, StringList files, FileFilter filter, int offset) {
        if (io.isDir()) {
            for (IOFile child : io.children(filter)) {
                IOFile.addDescendants(child, files, filter, offset);
            }
        } else if (filter == null || filter.accept(io.file)) {
            files.add(io.path().substring(offset));
        }
    }

    public static boolean isValidName(String name) {
        return VALIDNAME.matcher(name).matches();
    }

    public static boolean isValid(String path) {
        int c = path.indexOf(58);
        return c == -1 || !Prop.WIN || c == 1 && Token.letter(path.charAt(0)) && (path.indexOf(47) == 2 || path.indexOf(92) == 2);
    }

    public static String regex(String glob) {
        return IOFile.regex(glob, true);
    }

    public static String regex(String glob, boolean substring) {
        StringBuilder sb = new StringBuilder();
        for (String globs : Strings.split(glob, ',')) {
            String glb = globs.trim();
            if (sb.length() != 0) {
                sb.append('|');
            }
            boolean suffix = false;
            int gl = glb.length();
            for (int g = 0; g < gl; ++g) {
                char ch = glb.charAt(g);
                if (ch == '*') {
                    suffix = true;
                    sb.append(Strings.endsWith(glb, '.') ? "[^.]" : ".");
                } else if (ch == '?') {
                    ch = '.';
                    suffix = true;
                } else if (ch == '.') {
                    suffix = true;
                    if (g + 1 == glb.length()) break;
                    sb.append('\\');
                } else if (!Character.isLetterOrDigit(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            if (suffix || !substring) continue;
            sb.append(".*");
        }
        return Prop.CASE ? sb.toString() : sb.toString().toLowerCase(Locale.ENGLISH);
    }

    private static String create(String path, boolean directory) {
        StringList sl = new StringList();
        int l = path.length();
        TokenBuilder tb = new TokenBuilder(l);
        for (int i = 0; i < l; ++i) {
            char ch = path.charAt(i);
            if (ch == '\\' || ch == '/') {
                IOFile.add(tb, sl);
                continue;
            }
            tb.add(ch);
        }
        IOFile.add(tb, sl);
        if (path.startsWith("\\\\") || path.startsWith("//")) {
            tb.add("//");
        }
        int size = sl.size();
        for (int s = 0; s < size; ++s) {
            if (s != 0 || Strings.startsWith(path, '/')) {
                tb.add(47);
            }
            tb.add((String)sl.get(s));
        }
        boolean dir = directory;
        if (!dir && Prop.WIN && tb.size() == 2) {
            int c = Character.toLowerCase(tb.get(0));
            boolean bl = dir = c >= 97 && c <= 122 && tb.get(1) == 58;
        }
        if (dir) {
            tb.add(47);
        }
        return tb.toString();
    }

    private static void add(TokenBuilder tb, StringList sl) {
        String s = tb.toString();
        if (s.length() > 1 && s.charAt(1) == ':' && sl.isEmpty()) {
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        if ("..".equals(s) && !sl.isEmpty()) {
            if (((String)sl.get(sl.size() - 1)).indexOf(58) == -1) {
                sl.remove(sl.size() - 1);
            }
        } else if (!".".equals(s) && !s.isEmpty()) {
            sl.add(s);
        }
        tb.reset();
    }
}

