/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import org.basex.data.Data;
import org.basex.gui.view.tree.TreeBorder;
import org.basex.gui.view.tree.TreeNodeCache;

final class TreeSubtree {
    private final TreeNodeCache nc;
    private TreeBorder[][] border;

    TreeSubtree(Data d, boolean atts) {
        this.nc = new TreeNodeCache(d, atts);
    }

    void generateBorders(Data d, int[] roots) {
        int rl = roots.length;
        if (rl == 0) {
            return;
        }
        this.border = new TreeBorder[rl][];
        for (int i = 0; i < rl; ++i) {
            this.border[i] = this.nc.subtree(d, roots[i]);
        }
    }

    int prePerIndex(int rn, int lv, int ix) {
        return this.prePerIndex(this.treeBorder(rn, lv), ix);
    }

    private int prePerIndex(TreeBorder bo, int ix) {
        int start = bo.start + ix;
        if (start < 0) {
            return -1;
        }
        return this.nc.getPrePerLevelAndIndex(bo.level, start);
    }

    int preIndex(int rn, int lv, int pre) {
        return this.preIndex(this.treeBorder(rn, lv), pre);
    }

    private int preIndex(TreeBorder bo, int pre) {
        return this.nc.searchPreIndex(bo.level, pre, pre, bo.start, bo.getEnd()) - bo.start;
    }

    int levelSize(int rn, int lv) {
        return this.treeBorder((int)rn, (int)lv).size;
    }

    TreeBorder treeBorder(int rn, int lv) {
        return this.border[rn][lv];
    }

    int subtreeHeight(int rn) {
        return rn >= 0 && rn < this.border.length ? this.border[rn].length : -1;
    }

    int maxSubtreeHeight() {
        int h = 0;
        for (TreeBorder[] b : this.border) {
            int hh = b.length;
            if (hh <= h) continue;
            h = hh;
        }
        return h;
    }

    int searchPreArrayPos(int rn, int lv, int pre) {
        return this.searchPreArrayPos(this.treeBorder(rn, lv), pre);
    }

    private int searchPreArrayPos(TreeBorder bo, int pre) {
        return this.nc.searchPreArrayPos(bo.level, bo.start, bo.getEnd(), pre) - bo.start;
    }

    TreeBorder[] subtree(Data d, int pre) {
        return this.nc.subtree(d, pre);
    }
}

