/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.gui.GUIOptions;
import org.basex.gui.view.project.ProjectCache;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.SmartStrings;
import org.basex.util.Token;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

final class ProjectFiles {
    private static final int MAXHITS = 256;
    private static long parseId;
    private static long filterId;
    private final ProjectView view;
    private TreeMap<String, InputInfo> errors = new TreeMap();
    private ProjectCache cache;

    ProjectFiles(ProjectView view) {
        this.view = view;
    }

    void reset() {
        this.cache = null;
        ++filterId;
        ++parseId;
    }

    TreeMap<String, InputInfo> errors() {
        return this.errors;
    }

    String[] filter(String files, String contents, IOFile root) throws InterruptedException {
        long id = ++filterId;
        StringList results = new StringList();
        int[] search = new TokenParser(Token.lc(Token.token(contents))).toArray();
        ProjectCache pc = this.cache(root);
        if (files.contains("*") || files.contains("?")) {
            Pattern pt = Pattern.compile(IOFile.regex(files));
            for (String path : pc) {
                if (pt.matcher(path).matches() && ProjectFiles.filterContent(path, search)) {
                    results.add(path);
                    if (results.size() >= 256) break;
                }
                if (id == filterId) continue;
                throw new InterruptedException();
            }
        } else {
            ProjectFiles.filter(files, search, id, results, pc);
        }
        return (String[])results.finish();
    }

    void parse(IOFile root, Context ctx) throws InterruptedException {
        long id = ++parseId;
        HashSet<String> parsed = new HashSet<String>();
        TreeMap<String, InputInfo> errs = new TreeMap<String, InputInfo>();
        StringList paths = new StringList();
        StringList libs = new StringList();
        for (String path : this.cache(root)) {
            IOFile file = new IOFile(path);
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            (file.hasSuffix(".xqm") ? libs : paths).add(path);
        }
        paths.add(libs);
        for (String path : paths) {
            TokenMap modules;
            if (id != parseId) {
                throw new InterruptedException();
            }
            if (parsed.contains(path) || (modules = ProjectFiles.parse(path, ctx, errs)) == null) continue;
            for (byte[] mod : modules) {
                parsed.add(Token.string(mod));
            }
        }
        this.errors = errs;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    static TokenMap parse(String path, Context ctx, TreeMap<String, InputInfo> errs) {
        try {
            Throwable throwable = null;
            try (TextInput ti = new TextInput(new IOFile(path));){
                TokenMap tokenMap;
                Throwable throwable2;
                QueryContext qc;
                block30: {
                    block31: {
                        qc = new QueryContext(ctx);
                        throwable2 = null;
                        String input = ti.cache().toString();
                        boolean library = QueryProcessor.isLibrary(input);
                        qc.parse(input, library, path);
                        errs.remove(path);
                        tokenMap = qc.modParsed;
                        if (qc == null) break block30;
                        if (throwable2 == null) break block31;
                        try {
                            qc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block30;
                    }
                    qc.close();
                }
                return tokenMap;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (qc != null) {
                                    if (throwable2 != null) {
                                        try {
                                            qc.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        qc.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (QueryException ex) {
                            errs.put(path, ex.info());
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                }
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
        return null;
    }

    private ProjectCache cache(IOFile root) throws InterruptedException {
        ProjectCache pc = this.cache;
        if (pc == null) {
            this.cache = new ProjectCache(this.view.gui.gopts.get(GUIOptions.SHOWHIDDEN));
            this.cache.scan(Paths.get(root.path(), new String[0]), p -> p != this.cache);
        } else {
            while (!pc.valid()) {
                Performance.sleep(1L);
                if (pc == this.cache) continue;
                throw new InterruptedException();
            }
        }
        return this.cache;
    }

    private static void filter(String files, int[] search, long id, StringList results, ProjectCache cache) throws InterruptedException {
        String query = files.replace('\\', '/');
        HashSet<String> exclude = new HashSet<String>();
        for (boolean onlyName : new boolean[]{true, false}) {
            for (int mode = 0; mode < 5; ++mode) {
                for (String path : cache) {
                    String file;
                    if (exclude.contains(path)) continue;
                    String string = file = onlyName ? path.substring(path.lastIndexOf(47) + 1) : path;
                    if (mode == 0 ? SmartStrings.startsWith(file, query) : (mode == 1 ? SmartStrings.contains(file, query) : SmartStrings.matches(file, query))) {
                        if (ProjectFiles.filterContent(path, search)) {
                            results.add(path);
                            if (results.size() >= 256) {
                                return;
                            }
                        }
                        exclude.add(path);
                    }
                    if (id == filterId) continue;
                    throw new InterruptedException();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean filterContent(String path, int[] search) {
        int cl = search.length;
        if (cl == 0) {
            return true;
        }
        try (TextInput ti = new TextInput(new IOFile(path));){
            IntList il = new IntList(cl - 1);
            int c = 0;
            while (true) {
                block25: {
                    if (!il.isEmpty()) {
                        if (il.remove(0) == search[c]) {
                            ++c;
                            continue;
                        }
                        c = 0;
                        continue;
                    }
                    do {
                        int i;
                        if ((i = ti.read()) == -1 || !XMLToken.valid(i)) {
                            boolean bl = false;
                            return bl;
                        }
                        int cp = Token.lc(i);
                        if (c > 0) {
                            il.add(cp);
                        }
                        if (cp != search[c]) break block25;
                    } while (++c != cl);
                    boolean bl = true;
                    return bl;
                }
                c = 0;
                continue;
                break;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }
}

