/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.core.cmd.Test;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXHeader;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.listener.LinkListener;
import org.basex.gui.text.SearchEditor;
import org.basex.gui.text.TextPanel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.query.QueryTracer;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class InfoView
extends View
implements LinkListener,
QueryTracer {
    private static final String[] CATEGORIES = new String[]{Text.ALL, Text.COMMAND, Text.ERROR, Text.EVALUATING, Text.COMPILING, Text.OPTIMIZED_QUERY, Text.QUERY, Text.RESULT, Text.TIMING, Text.QUERY_PLAN};
    private final SearchEditor editor;
    private final BaseXHeader header;
    private final BaseXCombo cats;
    private final BaseXLabel label;
    private final TextPanel text;
    private boolean paint;
    private String cat = Text.ALL;
    private IntList stat = new IntList(4L);
    private StringList strings = new StringList(4L);
    private byte[] all = Token.EMPTY;
    private byte[] newText;
    private boolean clear;
    private int focus = -1;
    private int w;
    private int h;
    private int bw;
    private int bs;

    public InfoView(ViewNotifier notifier) {
        super("info", notifier);
        this.border(5).layout(new BorderLayout(0, 5));
        this.header = new BaseXHeader(Text.INFO);
        this.cats = new BaseXCombo((BaseXWindow)this.gui, Text.ALL);
        String maxString = "";
        for (String c : CATEGORIES) {
            if (c.length() <= maxString.length()) continue;
            maxString = c;
        }
        this.cats.setPrototypeDisplayValue(maxString);
        this.cats.addActionListener(ev -> {
            int e;
            while (this.paint) {
                Thread.yield();
            }
            this.cat = this.cats.getSelectedItem();
            byte[] start = new TokenBuilder().bold().add(this.cat).add(":").norm().nline().finish();
            byte[] end = new TokenBuilder().bold().finish();
            int s = Token.indexOf(this.all, start);
            this.newText = s != -1 ? Token.substring(this.all, s, (e = Token.indexOf(this.all, end, s + start.length)) != -1 ? e : this.all.length) : this.all;
            this.repaint();
        });
        this.label = new BaseXLabel(" ").resize(1.2f);
        this.text = new TextPanel(this.gui, false);
        this.text.setLinkListener(this);
        this.editor = new SearchEditor(this.gui, this.text);
        BaseXBack buttons = new BaseXBack(false);
        buttons.layout(new ColumnLayout());
        buttons.add(this.editor.button(Text.FIND));
        BaseXBack top = new BaseXBack(false);
        top.layout(new ColumnLayout(10));
        top.add(buttons);
        top.add(this.cats);
        top.add(this.label);
        BaseXBack north = new BaseXBack(false).layout(new BorderLayout());
        north.add((Component)top, "West");
        north.add((Component)this.header, "East");
        this.add((Component)north, "North");
        this.add((Component)this.editor, "Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public void refreshLayout() {
        this.text.setFont(GUIConstants.font);
        this.editor.bar().refreshLayout();
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWINFO);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWINFO, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void setInfo(String info, Command cmd, boolean ok, boolean reset) {
        this.setInfo(info, cmd, null, ok, reset);
    }

    public String setInfo(String info, Command cmd, String time, boolean ok, boolean reset) {
        TokenBuilder tb = new TokenBuilder().add(this.all);
        StringList eval = new StringList(1L);
        StringList comp = new StringList(1L);
        StringList plan = new StringList(1L);
        StringList result = new StringList(1L);
        StringList error = new StringList(1L);
        StringList origqu = new StringList(1L);
        StringList optqu = new StringList(1L);
        StringList command = new StringList(1L);
        StringList timings = new StringList(5L);
        IntList times = new IntList(5L);
        int runs = Math.max(1, this.gui.context.options.get(MainOptions.RUNS));
        String[] split = info.split(Text.NL);
        int sl = split.length;
        block0: for (int s = 0; s < sl; ++s) {
            String line = split[s];
            if (line.startsWith(Text.PARSING_CC) || line.startsWith(Text.COMPILING_CC) || line.startsWith(Text.EVALUATING_CC) || line.startsWith(Text.PRINTING_CC) || line.startsWith(Text.TOTAL_TIME_CC)) {
                int t = line.indexOf(" ms");
                int d = line.indexOf(58);
                int tm = (int)(Double.parseDouble(line.substring(d + 1, t)) * 100.0);
                times.add(tm);
                String key = line.substring(0, d).trim();
                String val = Performance.getTime((long)tm * 10000L * (long)runs, runs);
                timings.add("- " + key + ": " + val);
                continue;
            }
            if (line.startsWith(Text.HITS_X_CC) || line.startsWith(Text.UPDATED_CC) || line.startsWith(Text.PRINTED_CC) || line.startsWith(Text.READ_LOCKING_CC) || line.startsWith(Text.WRITE_LOCKING_CC)) {
                result.add("- " + line);
                continue;
            }
            if (line.equals(Text.COMPILING + ":")) {
                while (++s < sl && !split[s].isEmpty()) {
                    comp.add(split[s]);
                }
                continue;
            }
            if (line.equals(Text.QUERY + ":")) {
                while (++s < sl && !split[s].isEmpty()) {
                    origqu.add(split[s]);
                }
                continue;
            }
            if (line.equals(Text.OPTIMIZED_QUERY + ":")) {
                while (++s < sl && !split[s].isEmpty()) {
                    optqu.add(split[s]);
                }
                continue;
            }
            if (line.startsWith(Text.EVALUATING)) {
                while (++s < sl && split[s].startsWith("- ")) {
                    eval.add(split[s].substring(2).replaceAll("\\|", "\n"));
                }
                continue;
            }
            if (line.equals(Text.QUERY_PLAN + ":")) {
                while (++s < sl && !split[s].isEmpty()) {
                    plan.add(split[s]);
                }
                continue;
            }
            if (line.equals(Text.ERROR + ":")) {
                while (++s < sl && !split[s].isEmpty()) {
                    Pattern pattern = Pattern.compile(Text.STOPPED_AT + "(.*)" + ":");
                    Matcher matcher = pattern.matcher(split[s]);
                    if (matcher.find()) {
                        TokenBuilder tmp = new TokenBuilder();
                        tmp.add(Text.STOPPED_AT).uline().add(matcher.group(1)).uline().add(":");
                        split[s] = tmp.toString();
                    }
                    error.add(split[s]);
                }
                continue;
            }
            if (line.equals("Stack Trace:")) {
                while (++s < sl && !split[s].isEmpty()) {
                    boolean last;
                    TokenBuilder tmp = new TokenBuilder();
                    String sp = split[s].replaceAll("<.*", "");
                    boolean bl = last = !sp.equals(split[s]);
                    if (sp.startsWith("- ")) {
                        tmp.add("- ").uline().add(sp.substring(2)).uline();
                    } else {
                        tmp.add(sp);
                    }
                    error.add(tmp.toString());
                    if (!last) continue;
                    continue block0;
                }
                continue;
            }
            if (ok || line.isEmpty()) continue;
            error.add(line);
        }
        this.stat = times;
        this.strings = timings;
        boolean test = cmd instanceof Test;
        boolean query = cmd instanceof AQuery;
        if (this.clear || !times.isEmpty() || !ok && !test) {
            tb.reset();
        } else if (test) {
            eval.add(tb.toString().trim());
            tb.reset();
        }
        String inf = null;
        if (!query) {
            if (cmd != null) {
                command.add(cmd.toString());
            }
            if (ok && !info.isEmpty()) {
                if (reset) {
                    result.add(info.trim());
                } else if (cmd == null) {
                    inf = info.trim();
                }
            }
        }
        StringList list = (StringList)((Object)new StringList().add(Text.ALL));
        InfoView.add(Text.COMMAND, command, tb, list);
        InfoView.add(Text.ERROR, error, tb, list);
        InfoView.add(Text.EVALUATING, eval, tb, list);
        InfoView.add(Text.COMPILING, comp, tb, list);
        InfoView.add(Text.OPTIMIZED_QUERY, optqu, tb, list);
        InfoView.add(Text.QUERY, origqu, tb, list);
        InfoView.add(Text.RESULT, result, tb, list);
        InfoView.add(Text.TIMING, timings, tb, list);
        InfoView.add(Text.QUERY_PLAN, plan, tb, list);
        if (inf != null) {
            tb.add(inf).nline();
        }
        this.clear = reset;
        String total = time;
        if (!times.isEmpty()) {
            total = Performance.getTime((long)times.get(times.size() - 1) * 10000L * (long)runs, runs);
        }
        if (total != null) {
            this.setTime(Text.TOTAL_TIME_CC + total);
        }
        this.all = tb.finish();
        this.newText = this.all;
        this.cats.setItems((String[])list.toArray());
        this.cats.setSelectedItem(this.cat);
        this.repaint();
        return total;
    }

    private static void add(String head, StringList list, TokenBuilder tb, StringList cats) {
        if (list.isEmpty()) {
            return;
        }
        tb.bold().add(head).add(":").norm().nline();
        for (String s : list) {
            tb.add(s).nline();
        }
        tb.hline();
        cats.add(head);
    }

    @Override
    public void linkClicked(String link) {
        this.gui.editor.jump(link);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.focus = -1;
        if (e.getY() < this.h) {
            for (int i = 0; i < l; ++i) {
                int bx = this.w - this.bw + this.bs * i;
                if (e.getX() < bx || e.getX() >= bx + this.bs) continue;
                this.focus = i;
            }
        }
        this.setTime(((String)this.strings.get(this.focus == -1 ? l - 1 : this.focus)).replace("- ", ""));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paint = true;
        if (this.newText != null) {
            this.text.setText(this.newText);
            this.newText = null;
        }
        super.paintComponent(g);
        int l = this.stat.size();
        if (l != 0) {
            int bx;
            int i;
            int fs = GUIConstants.fontSize;
            this.h = this.header.getHeight() - 4;
            this.w = (int)((double)this.getWidth() * 0.98 - (double)fs / 2.0 - (double)this.header.getWidth());
            this.bw = (fs << 1) + this.w / 10;
            this.bs = this.bw / (l - 1);
            int m = 1;
            for (int i2 = 0; i2 < l - 1; ++i2) {
                m = Math.max(m, this.stat.get(i2));
            }
            int by = 8;
            int bh = this.h - 8;
            for (i = 0; i < l - 1; ++i) {
                if (i != this.focus) continue;
                bx = this.w - this.bw + this.bs * i;
                g.setColor(GUIConstants.color3);
                g.fillRect(bx, 8, this.bs + 1, bh);
            }
            for (i = 0; i < l - 1; ++i) {
                bx = this.w - this.bw + this.bs * i;
                g.setColor(GUIConstants.color((i == this.focus ? 3 : 2) + (i << 1)));
                int p = Math.max(1, this.stat.get(i) * bh / m);
                g.fillRect(bx, 8 + bh - p, this.bs, p);
                g.setColor(GUIConstants.color(8));
                g.drawRect(bx, 8 + bh - p, this.bs, p - 1);
            }
        }
        this.paint = false;
    }

    @Override
    public boolean print(String info) {
        if (this.clear || this.all.length < 50000) {
            this.setInfo(info, null, true, false);
        }
        return true;
    }

    private void setTime(String info) {
        long ms = Long.parseLong(info.replaceAll("^.+: |\\..+", ""));
        if (ms >= 60000L) {
            long seconds = ms / 1000L;
            long minutes = seconds % 3600L / 60L;
            long hours = seconds / 3600L;
            String frac = info.replaceAll("^.+\\.| ms.*", "");
            String time = String.format("%02d:%02d:%02d.%s", hours, minutes, seconds % 60L, frac);
            this.label.setText(info.replaceAll("\\d+\\.\\d+ ms", time.replaceAll("^00:", "")));
        } else {
            this.label.setText(info);
        }
    }
}

