/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXImages;
import org.basex.util.Prop;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUIMenuCmd[] TOOLBAR = new GUIMenuCmd[]{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.C_INFO, GUIMenuCmd.C_CLOSE, null, GUIMenuCmd.C_GOHOME, GUIMenuCmd.C_GOBACK, GUIMenuCmd.C_GOUP, GUIMenuCmd.C_GOFORWARD, null, GUIMenuCmd.C_SHOWEDITOR, GUIMenuCmd.C_SHOWRESULT, GUIMenuCmd.C_SHOWINFO, null, GUIMenuCmd.C_SHOWMAP, GUIMenuCmd.C_SHOWTREE, GUIMenuCmd.C_SHOWFOLDER, GUIMenuCmd.C_SHOWPLOT, GUIMenuCmd.C_SHOWTABLE, GUIMenuCmd.C_SHOWEXPLORE};
    static final String[] MENUBAR = new String[]{Text.DATABASE, Text.EDITOR, Text.VIEW, Text.VISUALIZATION, Text.OPTIONS, Text.HELP};
    static final GUICommand[][] MENUITEMS = new GUICommand[][]{{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_INFO, GUIMenuCmd.C_EXPORT, GUIMenuCmd.C_CLOSE, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_EXIT}, {GUIMenuCmd.C_EDITNEW, GUIMenuCmd.C_EDITOPEN, GUIMenuCmd.C_EDITREOPEN, GUIMenuCmd.C_EDITSAVE, GUIMenuCmd.C_EDITSAVEAS, GUIMenuCmd.C_EDITCLOSE, GUIMenuCmd.C_EDITCLOSEALL, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_FORMAT, GUIMenuCmd.C_COMMENT, GUIMenuCmd.C_SORT, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_LOWERCASE, GUIMenuCmd.C_UPPERCASE, GUIMenuCmd.C_TITLECASE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_BRACKET, GUIMenuCmd.C_JUMPFILE, GUIMenuCmd.C_NEXTERROR, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_VARS}, {GUIMenuCmd.C_SHOWEDITOR, GUIMenuCmd.C_SHOWPROJECT, GUIMenuCmd.C_FILESEARCH, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOWRESULT, GUIMenuCmd.C_SHOWINFO, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOWBUTTONS, GUIMenuCmd.C_SHOWINPUT, GUIMenuCmd.C_SHOWSTATUS, Prop.MAC ? null : GUIMenuCmd.C_FULL}, {GUIMenuCmd.C_SHOWMAP, GUIMenuCmd.C_SHOWTREE, GUIMenuCmd.C_SHOWFOLDER, GUIMenuCmd.C_SHOWPLOT, GUIMenuCmd.C_SHOWTABLE, GUIMenuCmd.C_SHOWEXPLORE}, {GUIMenuCmd.C_RTEXEC, GUIMenuCmd.C_RTFILTER, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COLOR, GUIMenuCmd.C_FONTS, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_PACKAGES, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_PREFS}, {GUIMenuCmd.C_HELP, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COMMUNITY, GUIMenuCmd.C_UPDATES, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOWMEM, Prop.MAC ? null : GUIMenuCmd.C_ABOUT}};
    public static final GUIMenuCmd[] POPUP = new GUIMenuCmd[]{GUIMenuCmd.C_GOBACK, GUIMenuCmd.C_FILTER, null, GUIMenuCmd.C_COPY, GUIMenuCmd.C_PASTE, GUIMenuCmd.C_DELETE, GUIMenuCmd.C_INSERT, GUIMenuCmd.C_EDIT, null, GUIMenuCmd.C_COPYPATH};
    public static final Cursor CURSORARROW = new Cursor(0);
    public static final Cursor CURSORHAND = new Cursor(12);
    public static final Cursor CURSORWAIT = new Cursor(3);
    public static final Cursor CURSORMOVEH = new Cursor(11);
    public static final Cursor CURSORMOVEV = new Cursor(8);
    public static final Cursor CURSORTEXT = new Cursor(2);
    public static final Cursor CURSORMOVE = new Cursor(13);
    private static final JTextField TEXTFIELD = new JTextField();
    private static final JLabel LABEL = new JLabel();
    public static final Color BACK = new Color(TEXTFIELD.getBackground().getRGB());
    public static final Color TEXT = new Color(TEXTFIELD.getForeground().getRGB());
    public static final Color PANEL = new Color(LABEL.getBackground().getRGB());
    public static final Color RED = GUIConstants.color(224, 0, 0);
    public static final Color LRED = GUIConstants.color(255, 216, 216);
    public static final Color GREEN = GUIConstants.color(0, 160, 0);
    public static final Color BLUE = GUIConstants.color(0, 64, 192);
    public static final Color KEYWORD = GUIConstants.color(32, 96, 176);
    public static final Color COMMENT = GUIConstants.color(0, 160, 160);
    public static final Color DIGIT = GUIConstants.color(192, 112, 32);
    public static final Color VARIABLE = GUIConstants.color(32, 160, 32);
    public static final Color VALUE = GUIConstants.color(112, 112, 112);
    public static Color lgray;
    public static Color gray;
    public static Color mgray;
    public static Color dgray;
    private static final Color[] COLORS;
    private static final boolean INVERT;
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color color1A;
    public static Color color2A;
    public static Color color3A;
    public static Color colormark1A;
    public static Color colormark2A;
    public static Font font;
    public static Font bfont;
    public static Font mfont;
    public static Font dmfont;
    public static int fontSize;
    public static final int NO_MOD = 0;
    public static final int SHIFT = 64;
    public static final int ALT = 512;
    public static final int CTRL = 128;
    public static final int META;

    private GUIConstants() {
    }

    public static synchronized void init(GUIOptions opts) {
        lgray = GUIConstants.color(224, 224, 224);
        gray = GUIConstants.color(160, 160, 160);
        mgray = GUIConstants.color(128, 128, 128);
        dgray = GUIConstants.color(64, 64, 64);
        int r = opts.get(GUIOptions.COLORRED);
        int g = opts.get(GUIOptions.COLORGREEN);
        int b = opts.get(GUIOptions.COLORBLUE);
        int cl = COLORS.length;
        for (int c = 1; c < cl + 1; ++c) {
            GUIConstants.COLORS[c - 1] = GUIConstants.color(Math.max(255 - c * r, 0), Math.max(255 - c * g, 0), Math.max(255 - c * b, 0));
        }
        color1 = GUIConstants.color(GUIConstants.darker(r, 24), GUIConstants.darker(g, 25), GUIConstants.darker(b, 40));
        color2 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 32), GUIConstants.darker(b, 44));
        color3 = GUIConstants.color(GUIConstants.darker(r, 48), GUIConstants.darker(g, 50), GUIConstants.darker(b, 40));
        color4 = GUIConstants.color(GUIConstants.darker(r, 140), GUIConstants.darker(g, 100), GUIConstants.darker(b, 70));
        colormark1 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 120), GUIConstants.darker(b, 240));
        colormark2 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 80), GUIConstants.darker(b, 160));
        colormark3 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320));
        colormark4 = GUIConstants.color(GUIConstants.darker(r, 1), GUIConstants.darker(g, 40), GUIConstants.darker(b, 80));
        Color col = COLORS[16];
        color1A = GUIConstants.color(GUIConstants.darker(r, 110), GUIConstants.darker(g, 150), GUIConstants.darker(b, 160), 100);
        color2A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 50);
        color3A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 30);
        colormark1A = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320), 100);
        colormark2A = GUIConstants.color(GUIConstants.darker(r, 12), GUIConstants.darker(g, 60), GUIConstants.darker(b, 120), 100);
        String name = opts.get(GUIOptions.FONT);
        int type = opts.get(GUIOptions.FONTTYPE);
        fontSize = opts.get(GUIOptions.FONTSIZE);
        font = new Font(name, type, fontSize);
        mfont = new Font(opts.get(GUIOptions.MONOFONT), type, fontSize);
        bfont = new Font(name, 1, fontSize);
        dmfont = new Font(opts.get(GUIOptions.MONOFONT), 0, GUIConstants.fontSize());
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    public static int fontSize() {
        return LABEL.getFont().getSize();
    }

    private static int darker(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    private static Color color(int r, int g, int b) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b) : new Color(r, g, b);
    }

    private static Color color(int r, int g, int b, int a) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b, 255 - a) : new Color(r, g, b, a);
    }

    static {
        COLORS = new Color[100];
        INVERT = BACK.getRed() + BACK.getGreen() + BACK.getBlue() < 384;
        META = Prop.MAC ? 256 : 128;
    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXImages.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

