/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.locks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.Job;
import org.basex.core.locks.FairLockQueue;
import org.basex.core.locks.LocalReadWriteLock;
import org.basex.core.locks.LockList;
import org.basex.core.locks.LockQueue;
import org.basex.core.locks.Locks;
import org.basex.core.locks.NonfairLockQueue;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Locking {
    public static final String INTERNAL_PREFIX = "internal:";
    public static final String BASEX_PREFIX = "basex:";
    public static final String CONTEXT = "internal:context";
    public static final String COLLECTION = "internal:collection";
    public static final String USER = "internal:user";
    public static final String BACKUP = "internal:backup";
    public static final String REPO = "internal:repo";
    private final boolean fair;
    private final ConcurrentMap<Long, Locks> locked = new ConcurrentHashMap<Long, Locks>();
    private final LockQueue queue;
    private final ReentrantReadWriteLock globalLocks;
    private final Map<String, LocalReadWriteLock> localLocks = new HashMap<String, LocalReadWriteLock>();
    private final Object globalLock = new Object();
    private int localWriters;
    private int globalReaders;

    public Locking(StaticOptions soptions) {
        this.fair = soptions.get(StaticOptions.FAIRLOCK);
        this.globalLocks = new ReentrantReadWriteLock(this.fair);
        int parallel = Math.max(soptions.get(StaticOptions.PARALLEL), 1);
        this.queue = this.fair ? new FairLockQueue(parallel) : new NonfairLockQueue(parallel);
    }

    public void acquire(Job job, Context ctx) {
        job.addLocks();
        Locks locks = job.jc().locks;
        locks.finish(ctx);
        try {
            this.acquire(locks);
        }
        catch (InterruptedException ex) {
            throw Util.notExpected("Thread was interrupted: %", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(Locks locks) throws InterruptedException {
        Long id = Thread.currentThread().getId();
        if (this.locked.containsKey(id)) {
            throw new IllegalMonitorStateException("Thread holds locks: " + id);
        }
        this.locked.put(id, locks);
        LockList reads = locks.reads;
        LockList writes = locks.writes;
        boolean write = writes.locking();
        boolean read = reads.locking();
        boolean lock = read || write;
        this.queue.acquire(id, read, write);
        if (lock) {
            ((Lock)(writes.global() ? this.globalLocks.writeLock() : this.globalLocks.readLock())).lock();
        }
        Object object = this.globalLock;
        synchronized (object) {
            if (writes.local()) {
                while (this.globalReaders > 0) {
                    this.globalLock.wait();
                }
                ++this.localWriters;
            }
            if (reads.global()) {
                while (this.localWriters > 1 || this.localWriters == 1 && !writes.local()) {
                    this.globalLock.wait();
                }
                ++this.globalReaders;
            }
        }
        int w = 0;
        int r = 0;
        int rs = reads.size();
        int ws = writes.size();
        while (r < rs || w < ws) {
            if (w < ws && (r == rs || writes.get(w).compareTo(reads.get(r)) <= 0)) {
                this.pin(writes.get(w++)).writeLock().lock();
                continue;
            }
            this.pin(reads.get(r++)).readLock().lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Long id = Thread.currentThread().getId();
        Locks locks = (Locks)this.locked.remove(id);
        LockList reads = locks.reads;
        LockList writes = locks.writes;
        boolean lock = reads.locking() || writes.locking();
        for (String string : reads) {
            this.unpin(string).readLock().unlock();
        }
        for (String string : writes) {
            this.unpin(string).writeLock().unlock();
        }
        Object object = this.globalLock;
        synchronized (object) {
            if (reads.global()) {
                --this.globalReaders;
                this.globalLock.notifyAll();
            }
        }
        object = this.globalLock;
        synchronized (object) {
            if (writes.local()) {
                --this.localWriters;
                this.globalLock.notifyAll();
            }
        }
        if (lock) {
            ((Lock)(writes.global() ? this.globalLocks.writeLock() : this.globalLocks.readLock())).unlock();
        }
        this.queue.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalReadWriteLock pin(String string) {
        Map<String, LocalReadWriteLock> map = this.localLocks;
        synchronized (map) {
            LocalReadWriteLock lock = this.localLocks.computeIfAbsent(string, k -> new LocalReadWriteLock(this.fair));
            lock.pin();
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalReadWriteLock unpin(String string) {
        Map<String, LocalReadWriteLock> map = this.localLocks;
        synchronized (map) {
            LocalReadWriteLock lock = this.localLocks.get(string);
            if (lock.unpin()) {
                this.localLocks.remove(string);
            }
            return lock;
        }
    }

    public static String[] queryLocks(byte[] string) {
        StringList list = new StringList();
        for (byte[] lock : Token.split(string, 44)) {
            list.add(BASEX_PREFIX + Token.string(lock).trim());
        }
        if (list.isEmpty()) {
            list.add(BASEX_PREFIX);
        }
        return (String[])list.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder(Prop.NL).append("Locking").append(Prop.NL);
        String in = "| ";
        sb.append("| ").append(this.queue).append(Prop.NL);
        sb.append("| ").append("Held locks by object:").append(Prop.NL);
        Map<String, LocalReadWriteLock> map = this.localLocks;
        synchronized (map) {
            this.localLocks.forEach((key, value) -> sb.append("| ").append("| ").append((String)key).append(" -> ").append(value).append(Prop.NL));
        }
        sb.append("| ").append("Held locks by job:").append(Prop.NL);
        this.locked.forEach((key, value) -> sb.append("| ").append("| ").append(key).append(" -> ").append(value).append(Prop.NL));
        return sb.toString();
    }
}

