/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Delete
extends ACreate {
    public Delete(String target) {
        super(Perm.WRITE, true, target);
    }

    @Override
    protected boolean run() {
        final Data data = this.context.data();
        final String target = this.args[0];
        return this.update(data, new ACreate.Code(){

            @Override
            boolean run() {
                IntList docs = data.resources.docs(target);
                AtomicUpdateCache auc = new AtomicUpdateCache(data);
                int ds = docs.size();
                for (int d = 0; d < ds; ++d) {
                    auc.addDelete(docs.get(d));
                }
                auc.execute(false);
                Delete.this.context.invalidate();
                TokenList bins = data.resources.binaries(target);
                Delete.deleteBinary(data, target);
                return Delete.this.info(Text.RES_DELETED_X_X, new Object[]{docs.size() + bins.size(), Delete.this.jc().performance});
            }
        });
    }

    public static void deleteBinary(Data data, String path) {
        if (data.inMemory()) {
            return;
        }
        IOFile file = data.meta.binary(path);
        if (file != null) {
            file.delete();
        }
    }
}

