/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Util;

public abstract class AQuery
extends Command {
    protected final HashMap<String, Object> vars = new HashMap();
    protected final HashMap<String, Object> props = new HashMap();
    private QueryProcessor qp;
    private QueryInfo info;
    private Value result;
    private boolean plan;

    AQuery(boolean openDB, String ... args) {
        super(Perm.NONE, openDB, args);
    }

    final boolean query(String query) {
        String error;
        if (this.exception != null) {
            error = Util.message(this.exception);
        } else {
            try {
                long hits = 0L;
                boolean run = this.options.get(MainOptions.RUNQUERY);
                boolean serial = this.options.get(MainOptions.SERIALIZE);
                boolean compplan = this.options.get(MainOptions.COMPPLAN);
                int runs = Math.max(1, this.options.get(MainOptions.RUNS));
                for (int r = 0; r < runs; ++r) {
                    if (r != 0) {
                        this.qp = null;
                        this.popJob();
                    }
                    this.init(query, this.context);
                    if (!compplan) {
                        this.queryPlan();
                    }
                    Performance perf = new Performance();
                    for (Map.Entry<String, Object> entry : this.vars.entrySet()) {
                        String name = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof Value) {
                            Value val = (Value)value;
                            if (name == null) {
                                this.qp.context(val);
                                continue;
                            }
                            this.qp.bind(name, val);
                            continue;
                        }
                        String[] strings = (String[])value;
                        if (name == null) {
                            this.qp.context(strings[0], strings[1]);
                            continue;
                        }
                        this.qp.bind(name, strings[0], strings[1]);
                    }
                    this.qp.compile();
                    this.info.compiling += perf.ns();
                    if (compplan) {
                        this.queryPlan();
                    }
                    if (!run) continue;
                    PrintOutput po = r == 0 && serial ? this.out : new NullOutput();
                    try (Serializer ser = this.qp.getSerializer(po);){
                        if (this.maxResults >= 0) {
                            this.result = this.qp.cache(this.maxResults);
                            this.info.evaluating += perf.ns();
                            this.result.serialize(ser);
                            hits = this.result.size();
                        } else {
                            Item item;
                            hits = 0L;
                            Iter iter = this.qp.iter();
                            this.info.evaluating += perf.ns();
                            while ((item = iter.next()) != null) {
                                ser.serialize(item);
                                ++hits;
                                this.checkStop();
                            }
                        }
                    }
                    this.qp.close();
                    this.info.serializing += perf.ns();
                }
                boolean bl = this.info(this.info.toString(this.qp, this.out.size(), hits, this.jc().locks), new Object[0]);
                return bl;
            }
            catch (IOException | QueryException ex) {
                this.exception = ex;
                error = Util.message(ex);
            }
            catch (JobException ex) {
                error = ex.getMessage();
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                error = QueryError.BASEX_OVERFLOW.message;
            }
            catch (RuntimeException ex) {
                this.extError("");
                throw ex;
            }
            finally {
                if (this.qp != null) {
                    this.qp.close();
                }
            }
        }
        this.queryPlan();
        return this.extError(error);
    }

    final boolean updates(Context ctx, String query) {
        try {
            this.init(query, ctx);
            return this.qp.updating;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            this.exception = ex;
            this.qp.close();
            return false;
        }
    }

    private void init(String query, Context ctx) throws QueryException {
        Performance perf = new Performance();
        if (this.qp == null) {
            this.qp = this.pushJob(new QueryProcessor(query, this.uri, ctx));
        }
        if (this.info == null) {
            this.info = this.qp.qc.info;
        }
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            this.qp.qc.putProperty(entry.getKey(), entry.getValue());
        }
        this.qp.parse();
        this.qp.qc.info.parsing += perf.ns();
    }

    public final String parameters(Context ctx) {
        try {
            this.init(this.args[0], ctx);
            String string = this.qp.qc.serParams().toString();
            return string;
        }
        catch (QueryException ex) {
            this.error(Util.message(ex), new Object[0]);
        }
        finally {
            this.qp = null;
            this.popJob();
        }
        return SerializerMode.DEFAULT.get().toString();
    }

    public void putExternal(String key, Object value) {
        this.props.put(key, value);
    }

    private boolean extError(String message) {
        StringBuilder sb = new StringBuilder();
        if (this.options.get(MainOptions.QUERYINFO).booleanValue()) {
            sb.append(this.info()).append(this.qp.info()).append(Text.NL).append(Text.ERROR).append(":").append(Text.NL);
        }
        sb.append(message);
        return this.error(sb.toString(), new Object[0]);
    }

    private void queryPlan() {
        if (!this.plan && this.qp != null) {
            try {
                if (this.options.get(MainOptions.XMLPLAN).booleanValue()) {
                    this.info(Text.NL + Text.QUERY_PLAN + ":", new Object[0]);
                    this.info(this.qp.plan().serialize().toString(), new Object[0]);
                }
                this.plan = true;
            }
            catch (Exception ex) {
                Util.stack(ex);
            }
        }
    }

    @Override
    public boolean updating(Context ctx) {
        return this.updates(ctx, this.args[0]);
    }

    @Override
    public final boolean updated(Context ctx) {
        return this.qp != null && this.qp.updates() != 0;
    }

    @Override
    public void addLocks() {
        if (this.qp == null) {
            this.jc().locks.writes.addGlobal();
        } else {
            this.qp.addLocks();
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().add(0);
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public final Value result() {
        Value r = this.result;
        this.result = null;
        return r;
    }
}

