/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobException;
import org.basex.core.locks.LockList;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.query.value.Value;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public abstract class Command
extends Job {
    public final String[] args;
    public final boolean openDB;
    protected Context context;
    protected MainOptions options;
    protected StaticOptions soptions;
    protected PrintOutput out;
    protected InputSource in;
    protected String uri = "";
    protected Exception exception;
    protected int maxResults = -1;
    private final TokenBuilder info = new TokenBuilder();
    private final Perm perm;

    protected Command(Perm perm, String ... args) {
        this(perm, false, args);
    }

    protected Command(Perm perm, boolean openDB, String ... args) {
        this.perm = perm;
        this.openDB = openDB;
        this.args = args;
    }

    public final void execute(Context ctx, OutputStream os) throws BaseXException {
        this.updating = this.updating(ctx);
        this.register(ctx);
        try {
            if (!this.run(ctx, os)) {
                BaseXException ex = new BaseXException(this.info(), new Object[0]);
                ex.initCause(this.exception);
                throw ex;
            }
        }
        catch (RuntimeException th) {
            Util.stack(th);
            throw th;
        }
        finally {
            this.unregister(ctx);
        }
    }

    public final String execute(Context ctx) throws BaseXException {
        ArrayOutput ao = new ArrayOutput();
        this.execute(ctx, ao);
        return ao.toString();
    }

    public final void setInput(InputStream input) {
        this.in = new InputSource(input);
    }

    public final void setInput(InputSource input) {
        this.in = input;
    }

    public final boolean run(Context ctx) {
        return this.run(ctx, new NullOutput());
    }

    public final String info() {
        return this.info.toString();
    }

    public final Exception exception() {
        return this.exception;
    }

    public Value result() {
        return null;
    }

    public boolean updating(Context ctx) {
        return this.perm == Perm.CREATE || this.perm == Perm.WRITE;
    }

    public boolean updated(Context ctx) {
        return this.updating(ctx);
    }

    public boolean newData(Context ctx) {
        return false;
    }

    public final void maxResults(int max) {
        this.maxResults = max;
    }

    public boolean supportsProg() {
        return false;
    }

    public boolean stoppable() {
        return false;
    }

    public final void init(Context ctx, OutputStream os) {
        this.context = ctx;
        this.options = ctx.options;
        this.soptions = ctx.soptions;
        this.out = PrintOutput.get(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean run(Context ctx, OutputStream os) {
        Data data = ctx.data();
        if (data == null && this.openDB) {
            return this.error(Text.NO_DB_OPENED, new Object[0]);
        }
        if (!ctx.perm(this.perm, data != null && !data.inMemory() ? data.meta.name : null)) {
            return this.error(Text.PERM_REQUIRED_X, new Object[]{this.perm});
        }
        this.init(ctx, os);
        try {
            this.checkStop();
            boolean bl = this.run();
            return bl;
        }
        catch (JobException ex) {
            boolean bl = this.error(ex.getMessage(), new Object[0]);
            return bl;
        }
        catch (OutOfMemoryError ex) {
            Performance.gc(2);
            Util.debug(ex);
            boolean bl = this.error(Text.OUT_OF_MEM + (this.perm == Perm.CREATE ? Text.H_OUT_OF_MEM : ""), new Object[0]);
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = this.error(Util.bug(ex) + Prop.NL + this.info, new Object[0]);
            return bl;
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
    }

    public final String toString(boolean conf) {
        CmdBuilder cb = new CmdBuilder(this, conf);
        this.build(cb);
        return cb.toString();
    }

    public Command baseURI(String base) {
        this.uri = base;
        return this;
    }

    public String baseURI() {
        return this.uri;
    }

    public final String toString() {
        return this.toString(false);
    }

    protected abstract boolean run() throws IOException;

    protected void build(CmdBuilder cb) {
        cb.init().args();
    }

    protected final boolean error(String msg, Object ... ext) {
        this.info.reset();
        this.info.addExt(msg == null ? "" : msg, ext);
        return false;
    }

    protected final boolean info(String str, Object ... ext) {
        if (!str.isEmpty()) {
            this.info.addExt(str, ext).add(Prop.NL);
        }
        return true;
    }

    protected final <E extends Enum<E>> E getOption(Class<E> typ) {
        E e = Command.getOption(this.args[0], typ);
        if (e == null) {
            this.error(Text.UNKNOWN_TRY_X, this.args[0]);
        }
        return e;
    }

    protected final boolean addLocks(LockList list, int index) {
        boolean noglob;
        if (this.args.length <= index || this.args[index] == null) {
            return true;
        }
        boolean bl = noglob = !this.args[index].matches(".*[?*,].*");
        if (noglob) {
            list.add(this.args[index]);
        }
        return noglob;
    }

    protected static <E extends Enum<E>> E getOption(String string, Class<E> type) {
        try {
            return Enum.valueOf(type, string.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception ex) {
            Util.debug(ex);
            return null;
        }
    }

    protected static boolean close(Context ctx, String db) {
        Data data = ctx.data();
        return data != null && db.equals(data.meta.name) && ctx.datas.pins(db) == 1 && Close.close(ctx);
    }
}

